from contextlib import contextmanager

from sandbox import sdk2

from sandbox.projects.common.arcadia import sdk
from sandbox.projects.maps.MapsBinaryBaseTask import MapsBinaryBaseTask


class MapsBinaryTask(MapsBinaryBaseTask):

    class Requirements(MapsBinaryBaseTask.Requirements):
        pass

    class Parameters(MapsBinaryBaseTask.Parameters):
        args = sdk2.parameters.List('Args for binary')
        options = sdk2.parameters.Dict('Options for binary')
        subcmd = sdk2.parameters.String('Subcmd', required=False)
        subcmd_options = sdk2.parameters.Dict('Options for subcmd', required=False)
        vault_options = sdk2.parameters.Dict('Vault options for binary')
        env_options = sdk2.parameters.Dict('Environment options for binary')
        vault_env_options = sdk2.parameters.Dict('Vault environment options for binary')
        mount_arcadia = sdk2.parameters.Bool('Mount and run binary from arcadia root', default=False)

    def on_execute(self):
        options = self.options_from_vault(self.Parameters.vault_options)
        options.update(self.Parameters.options)
        arcadia_context = self.empty_context()
        if self.Parameters.mount_arcadia:
            arcadia_context = self.mount_arcadia()
        env_options = self.options_from_vault(self.Parameters.vault_env_options)
        env_options.update(self.Parameters.env_options)
        with arcadia_context as arcadia:
            self.run_binary(
                options=self.convert_empty_to_true(options),
                arguments=self.Parameters.args,
                subcmd=self.Parameters.subcmd,
                subcmd_options=self.Parameters.subcmd_options,
                env_options=env_options,
                cwd=arcadia,
            )

    @staticmethod
    def mount_arcadia():
        return sdk.mount_arc_path('arcadia-arc:/#trunk', fetch_all=False)

    @staticmethod
    @contextmanager
    def empty_context():
        yield

    @staticmethod
    def options_from_vault(vault_options_dict):
        options = {}
        for option, vault_item in vault_options_dict.iteritems():
            owner, vault = vault_item.split(':') if ':' in vault_item else (None, vault_item)
            options[option] = sdk2.Vault.data(owner, vault)
        return options

    @staticmethod
    def convert_empty_to_true(options):
        return {k: True if v == '' else v for k, v in options.iteritems()}
