import os
import os.path
import subprocess

from sandbox.projects.common.build.YaMake import YaMakeTask
from sandbox import sdk2
import sandbox.projects.common.build.parameters as build_params
from sandbox.projects.common.arcadia import sdk
from sandbox.sandboxsdk import parameters
from sandbox.sandboxsdk import paths
from sandbox.common.errors import TaskFailure


class MapsStatisticsCubeMakerExecutable(sdk2.resource.AbstractResource):
    """
        Statistics-CubeMaker Binary
    """
    releasable = True
    executable = True
    any_arch = False
    ttl = 180


class MapsBuildStatisticsCubeMaker(YaMakeTask):
    type = 'MAPS_BUILD_STATISTICS_CUBE_MAKER'

    STATS_CUBE_MAKER_PATH = 'maps/statistics/cube_maker'

    input_parameters = [
        build_params.ArcadiaUrl
    ]


    def initCtx(self):
        self.ctx['fail_on_any_error'] = True
        YaMakeTask.initCtx(self)

    def get_targets(self):
        return [ self.STATS_CUBE_MAKER_PATH ]

    def get_arts(self):
        return [{'path': self.STATS_CUBE_MAKER_PATH}]

    def get_resources(self):
        return {
            'statistics_metrics': {
                'description': 'Statistics-CubeMaker executable',
                'resource_type': MapsStatisticsCubeMakerExecutable
            }
        }

    @property
    def release_template(self):
        return self.ReleaseTemplate(types=['stable'])


__Task__ = MapsBuildStatisticsCubeMaker
