import os
import os.path
import subprocess

from sandbox.projects.common.build.YaMake import YaMakeTask
from sandbox import sdk2
import sandbox.projects.common.build.parameters as build_params
from sandbox.projects.common.arcadia import sdk
from sandbox.sandboxsdk import parameters
from sandbox.sandboxsdk import paths
from sandbox.common.errors import TaskFailure


class MapsStatisticsLogPreprocessorExecutable(sdk2.resource.AbstractResource):
    """
        LogPreprocessor Binary
    """
    releasable = True
    executable = True
    any_arch = False
    ttl = 180


class MapsBuildStatisticsLogPreprocessor(YaMakeTask):
    type = 'MAPS_BUILD_STATISTICS_LOG_PREPROCESSOR'

    LOG_PREPROCESSOR_PATH = 'maps/statistics/log_preprocessor'

    input_parameters = [
        build_params.ArcadiaUrl
    ]


    def initCtx(self):
        self.ctx['fail_on_any_error'] = True
        YaMakeTask.initCtx(self)

    def get_targets(self):
        return [ self.LOG_PREPROCESSOR_PATH ]

    def get_arts(self):
        return [{'path': self.LOG_PREPROCESSOR_PATH}]

    def get_resources(self):
        return {
            'statistics_navi': {
                'description': 'Log Preprocessor executable',
                'resource_type': MapsStatisticsLogPreprocessorExecutable
            }
        }

    @property
    def release_template(self):
        return self.ReleaseTemplate(types=['stable'])


__Task__ = MapsBuildStatisticsLogPreprocessor
