import os
import os.path
import subprocess

from sandbox.projects.common.build.YaMake import YaMakeTask
from sandbox import sdk2
import sandbox.projects.common.build.parameters as build_params
from sandbox.projects.common.arcadia import sdk
from sandbox.sandboxsdk import parameters
from sandbox.sandboxsdk import paths
from sandbox.common.errors import TaskFailure


class MapsStatisticsMetricsExecutable(sdk2.resource.AbstractResource):
    """
        Statistics-Metrics Binary
    """
    releasable = True
    executable = True
    any_arch = False
    ttl = 180


class MapsBuildStatisticsMetrics(YaMakeTask):
    type = 'MAPS_BUILD_STATISTICS_METRICS'

    STATS_METRICS_PATH = 'maps/statistics/metrics'

    input_parameters = [
        build_params.ArcadiaUrl
    ]


    def initCtx(self):
        self.ctx['fail_on_any_error'] = True
        YaMakeTask.initCtx(self)

    def get_targets(self):
        return [ self.STATS_METRICS_PATH ]

    def get_arts(self):
        return [{'path': self.STATS_METRICS_PATH}]

    def get_resources(self):
        return {
            'statistics_metrics': {
                'description': 'Statistics-Metrics executable',
                'resource_type': MapsStatisticsMetricsExecutable
            }
        }

    @property
    def release_template(self):
        return self.ReleaseTemplate(types=['stable'])


__Task__ = MapsBuildStatisticsMetrics
