import subprocess

from sandbox import sdk2
from sandbox.common.errors import TaskFailure

from sandbox.projects.maps.common.ecstatic_bin import MapsEcstaticToolMixin, ECSTATIC_ENVIRONMENTS


class MapsEcstaticDatasetManager(MapsEcstaticToolMixin, sdk2.Task):
    class Requirements(sdk2.Requirements):
        cores = 1

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(sdk2.Parameters):

        with sdk2.parameters.String('Ecstatic environment') as environment:
            for key in ECSTATIC_ENVIRONMENTS:
                environment.values[key] = environment.Value(value=key, default=(key == "testing"))

        command = sdk2.parameters.String('Command to be performed', required=True)
        with sdk2.parameters.Group('Auth'):
            tvm_id = sdk2.parameters.Integer('TVM id')
            tvm_secret = sdk2.parameters.YavSecret('TVM secret')

    def on_execute(self):
        command = self.Parameters.command.split()
        try:
            self.ecstatic(self.Parameters.environment, command, tvm_id=self.Parameters.tvm_id,
                          tvm_secret_id=self.Parameters.tvm_secret.secret[0])
        except subprocess.CalledProcessError as e:
            self.set_info(e.output)
            raise TaskFailure('Ecstatic returned ' + str(e.returncode))
