import os

from sandbox import sdk2
import sandbox.common.types.misc as ctm

from sandbox.sandboxsdk.process import run_process

OWNER = 'MAPS_FRONT'


class MapsFrontBase(sdk2.Task):
    class Requirements(sdk2.Requirements):
        privileged = True
        disk_space = 4096
        dns = ctm.DnsType.DNS64
        ram = 16384
        cores = 8

    class Parameters(sdk2.Parameters):
        with sdk2.parameters.Group('GitHub') as github:
            repository = sdk2.parameters.String(
                'Repository',
                default='https://github.yandex-team.ru/maps/maps.git'
            )
            hash = sdk2.parameters.String('Commit', default='dev')

        with sdk2.parameters.Group('Run') as github:
            command = sdk2.parameters.String('Command', default='make build')

        _container = sdk2.parameters.Container(
            'Build environment',
            # type=LXC_CONTAINER,  # FIXME: invalid argument (SANDBOX-6404)
            # https://sandbox.yandex-team.ru/resource/555306303/view
            default_value=555306303,
            required=True
        )

        kill_timeout = 3600
        dump_disk_usage = False

    @property
    def environment(self):
        environment = os.environ.copy()

        vault_items = self.server.vault.read(owner=OWNER, limit=100).get('items', [])

        for item in vault_items:
            environment[item['name']] = sdk2.Vault.data(OWNER, item['name'])

        environment['SYNCHROPHAZOTRON'] = str(self.synchrophazotron)

        return environment

    def on_execute(self):
        src_root = os.path.abspath('src')

        params = self.Parameters

        run_process(['git', 'clone', params.repository, src_root], log_prefix='git_clone')
        run_process(['git', 'checkout', params.hash], log_prefix='git_checkout', work_dir=src_root)

        run_process(
            params.command,
            log_prefix='command',
            work_dir=src_root,
            environment=self.environment,
            shell=True
        )
