# -*- coding: utf-8 -*-

import logging
import logging.handlers
import os
import re
import time
import urllib2

from sandbox import sdk2


def logger():
    loggerr = logging.getLogger('%s_%s' % (__name__, time.time()))
    loggerr.setLevel(logging.DEBUG)
    formatter = logging.Formatter('%(asctime)s %(levelname)s [%(processName)s: %(threadName)s] %(message)s')
    file_handler = logging.handlers.RotatingFileHandler(
        'maps_gtbuilder_ammogen.log',
        maxBytes=1024 * 1024,
        backupCount=5
    )

    file_handler.setLevel(logging.DEBUG)
    file_handler.setFormatter(formatter)
    loggerr.addHandler(file_handler)
    return loggerr


class MapsGraphTileBuilderAmmo(sdk2.Resource):
    pass


class MapsGraphTileBuilderAmmoGen(sdk2.Task):

    class Requirements(sdk2.Requirements):
        cores = 1
        disk_space = 2048  # 2GB
        pass

    class Parameters(sdk2.Parameters):
        ammo_url = sdk2.parameters.Url('input ammo URL', required=True)
        required_graph_version = sdk2.parameters.String('required graph version', required=True)
        with sdk2.parameters.Output:
            ammo = sdk2.parameters.Resource('Ammo', required=True)

    def on_execute(self):
        logger().info(
            'ammo_url = [%s]; required_graph_version = [%s]',
            self.Parameters.ammo_url,
            self.Parameters.required_graph_version)
        ammo = MapsGraphTileBuilderAmmo(self, 'MapsGraphTileBuilderAmmo', 'output.ammo')
        url_request = urllib2.urlopen(self.Parameters.ammo_url)
        output_data = sdk2.ResourceData(ammo)
        substitute_version = 'v=' + self.Parameters.required_graph_version
        regexp = re.compile(r'v=[^$\&\s]*')
        with output_data.path.open(mode='w', encoding='ascii') as ammo_file:
            for line in url_request.readlines():
                sed_line = re.sub(regexp, substitute_version, line)
                ammo_file.write(sed_line.decode('ascii'))
        output_data.ready()
        self.Parameters.ammo = ammo
