# -*- coding: utf-8 -*-

import logging
import os

from sandbox import common
from sandbox.projects.common import file_utils


class Template(object):
    @staticmethod
    def get():
        filename = "xml_template.jinja2"

        if common.system.inside_the_binary():
            logging.info("Loading template from resources")
            from library.python import resource
            current_dir = "/sandbox/projects/maps/MapsInfopointsDangerUpdate/utils/"
            data = resource.find(os.path.join(current_dir, filename))
        else:
            logging.info("Loading template from file")
            data = file_utils.read_file(os.path.join(os.path.dirname(__file__), filename))

        import jinja2
        return jinja2.Template(data)
