import os

import sandbox.projects.maps.carparks.common.utils as utils
from sandbox import sdk2
from sandbox.common.errors import TaskFailure


class MapsInfopointsUgcExtractor(sdk2.Task):
    class Requirements(sdk2.Requirements):
        cores = 1

    class Parameters(sdk2.Parameters):
        yt_token_vault_name = sdk2.parameters.String(
            'YT token Sandbox Vault name',
            required=True,
            default='YT_TOKEN')

        infopoints_ugc_extractor_binary = sdk2.parameters.Resource(
            'Infopoints UGC Extractor binary',
            required=True)

        with sdk2.parameters.RadioGroup("Infopoints environment") as environment:
            environment.values.testing = None
            environment.values.production = None

    def _prepare_token(self):
        vault_owner = (
            'robot-jams' if self.Parameters.environment == 'production'
            else 'robot-jams-testing')

        os.environ['YT_TOKEN'] = sdk2.Vault.data(
            vault_owner,
            self.Parameters.yt_token_vault_name)

    def _extract_ugc(self):
        utils.run(self.Parameters.infopoints_ugc_extractor_binary,
                  '--environment', self.Parameters.environment)

    def on_execute(self):
        self._prepare_token()
        self._extract_ugc()
