from sandbox import sdk2

from sandbox.projects.maps.MapsBinaryBaseTask import MapsBinaryBaseTask


class MapsNavistopwatchAmmo(sdk2.Resource):
    sync_upload_to_mds = True


class MapsNavistopwatchAmmoGen(MapsBinaryBaseTask):

    class Requirements(MapsBinaryBaseTask.Requirements):
        pass

    class Parameters(MapsBinaryBaseTask.Parameters):
        binary_name = MapsBinaryBaseTask.Parameters.binary_name(default='gen-navistopwatch-ammo')
        installation = MapsBinaryBaseTask.Parameters.register_installations(['stable'], default='stable')
        version_file_path = MapsBinaryBaseTask.Parameters.version_file_path(
            default='maps/routing/router/regression/gen-stopwatch-ammo/binary_version.json')
        input = sdk2.parameters.Resource('Router requests', required=True)
        count = sdk2.parameters.Integer('Count', default=10**9)

        format = sdk2.parameters.String('Format', default='geometry')
        router = sdk2.parameters.String('Router', default='http://core-driving-router.testing.maps.yandex.net')

        with sdk2.parameters.Output:
            ammo = sdk2.parameters.Resource('Ammo', required=True)

    def on_execute(self):
        options = self.options_from_parameters(['count'])
        subcmd = "info"
        subcmd_options = self.options_from_parameters(['format', 'router'])
        ammo = MapsNavistopwatchAmmo(self, 'MapsNavistopwatchAmmo', 'output.ammo')
        input_data = sdk2.ResourceData(self.Parameters.input)
        output_data = sdk2.ResourceData(ammo)
        options.update({'input': input_data.path,
                        'output': output_data.path})
        self.run_binary(options, subcmd, subcmd_options)
        output_data.ready()
        self.Parameters.ammo = ammo
