from sandbox import sdk2

from sandbox.projects.maps.MapsBinaryBaseTask import MapsBinaryBaseTask
from sandbox.projects.maps.MapsNavistopwatchAmmoGen import MapsNavistopwatchAmmo
from sandbox.projects.masstransit.common.utils import DateParameter

YT_CLUSTER = "hahn"
TOKEN_KEY = "robot_robot-mtr_yql_token"


class MapsNavistopwatchAmmoGenMt(MapsBinaryBaseTask):

    class Requirements(MapsBinaryBaseTask.Requirements):
        pass

    class Parameters(MapsBinaryBaseTask.Parameters):
        binary_name = MapsBinaryBaseTask.Parameters.binary_name(default='gen-navistopwatch-ammo-mt')
        installation = MapsBinaryBaseTask.Parameters.register_installations(['stable'], default='stable')
        version_file_path = MapsBinaryBaseTask.Parameters.version_file_path(
            default='maps/routing/router/regression/gen-stopwatch-ammo-mt/binary_version.json')
        count = sdk2.parameters.Integer('Count', default=10**6)
        log_date = DateParameter("Date of log to filter", default=DateParameter.yesterday())

        with sdk2.parameters.Output:
            ammo = sdk2.parameters.Resource('Ammo', required=True)

    def on_execute(self):
        ammo = MapsNavistopwatchAmmo(self, 'MapsNavistopwatchAmmo', 'output.ammo')
        output_data = sdk2.ResourceData(ammo)
        self.run_binary(options={
            'output': output_data.path,
            'yt_cluster': YT_CLUSTER,
            'yt_token': sdk2.Vault.data(TOKEN_KEY),
            'date': self.Parameters.log_date,
            'ammo_count': self.Parameters.count})
        output_data.ready()
        self.Parameters.ammo = ammo
