from sandbox import sdk2

from sandbox.projects.maps.MapsBinaryBaseTask import MapsBinaryBaseTask

STARTREK_TOKEN_OWNER = "MAPS"
STARTREK_TOKEN_NAME = "STARTREK_TOKEN"


class MapsNotificationCounter(MapsBinaryBaseTask):

    class Requirements(MapsBinaryBaseTask.Requirements):
        pass

    class Parameters(MapsBinaryBaseTask.Parameters):
        binary_name = MapsBinaryBaseTask.Parameters.binary_name(default='notification_counter')
        till_date = sdk2.parameters.String('Date till which count notifications', required=False)
        days = sdk2.parameters.Integer('Interval in days before `till-date` to compute notifications',
                                      required=False, default=None)
        login = sdk2.parameters.String('Telegram chat used for notifications', required=False)
        top = sdk2.parameters.Integer('Top notification leaders', required=False, default=None)
        lsr_threshold = sdk2.parameters.Integer('Notification threshold (>=) to open tickets in MAPSLSR',
                                                required=False, default=None)

    def on_execute(self):
        options = self.options_from_parameters(['login', 'top', 'days', 'till_date', 'lsr_threshold'])
        options.update({'startrek_token': sdk2.Vault.data(STARTREK_TOKEN_OWNER, STARTREK_TOKEN_NAME)})
        self.run_binary(options)
