import requests
from requests.adapters import HTTPAdapter
from requests.packages.urllib3.util.retry import Retry
from sandbox.projects.tank.ShootViaTankapi import ShootViaTankapi

from sandbox.common.errors import TaskFailure


class MapsShootViaTankapi(ShootViaTankapi):
    def on_execute(self):
        super(MapsShootViaTankapi, self).on_execute()
        session = requests.session()
        adapter = HTTPAdapter(max_retries=Retry(10, backoff_factor=10))
        session.mount('http://', adapter)
        session.mount('https://', adapter)

        sla_result = session.get(
            'https://lunapark.yandex-team.ru/api/job/{}/sla.json'.format(self.Parameters.lunapark_job_id)
        ).json()[0]
        if not sla_result['resolution']:
            raise TaskFailure('Task did not passed sla')
