from sandbox import sdk2

from sandbox.projects.maps.MapsBinaryBaseTask import MapsBinaryBaseTask

STARTREK_TOKEN_OWNER = "MAPS"
STARTREK_TOKEN_NAME = "STARTREK_TOKEN"


class MapsStartrekComponent(MapsBinaryBaseTask):

    class Requirements(MapsBinaryBaseTask.Requirements):
        pass

    class Parameters(MapsBinaryBaseTask.Parameters):
        binary_name = MapsBinaryBaseTask.Parameters.binary_name(default='st_component')
        dry_run = sdk2.parameters.Bool('Debug: do not modify startrek')
        queue = sdk2.parameters.String('Queue in which components should be set ', default='MAPADMIN')
        override_component = sdk2.parameters.List('Components which should be overriden')

    def on_execute(self):
        options = self.options_from_parameters(['dry_run', 'queue', 'override_component'])
        self.run_binary(options=options, env_options={
            'startrek-token': sdk2.Vault.data(STARTREK_TOKEN_OWNER, STARTREK_TOKEN_NAME)})
