import os

import sandbox.common.types.resource as ctr
import sandbox.common.types.task as ctt

from sandbox import sdk2
from sandbox.sdk2.helpers import subprocess as sp
from sandbox.common.errors import TaskFailure, TaskStop

YT_POOL = 'stats-navi-prod'


class MapsStatisticsLogPreprocessor(sdk2.Task, object):
    """
    Executes StatisticsLogPreprocessor binary with given params
    """

    fail_on_any_error = True

    class Requirements(sdk2.Requirements):
        cores = 1  # 1 cores or less
        ram = 8192  # 8GiB or less

        class Caches(sdk2.Requirements.Caches):
            pass  # means that task do not use any shared caches


    class Parameters(sdk2.Parameters):
        with sdk2.parameters.String("Component", multiline=True, default='navigator') as component_parameter:
            component_parameter.values['navigator'] = 'navigator'
            component_parameter.values['maps'] = 'maps'
            component_parameter.values['auto'] = 'auto'


    def on_enqueue(self):
        running_tasks = sdk2.Task.find(
            MapsStatisticsLogPreprocessor,
            status=ctt.Status.Group.QUEUE + ctt.Status.Group.EXECUTE + ctt.Status.Group.WAIT,
            input_parameters={
                'component_parameter': self.Parameters.component_parameter
            }
        ).limit(10)

        ids = set([task.id for task in running_tasks])
        ids.discard(self.id)

        if len(ids) > 0:
            raise TaskStop('There are other tasks enqueued/executing with same parmeters. Stopping.')


    def on_execute(self):
        resource  = sdk2.Resource["MAPS_STATISTICS_LOG_PREPROCESSOR_EXECUTABLE"].find(
            state=ctr.State.READY
        ).order(-sdk2.Resource.id).first()

        resource_data = sdk2.ResourceData(resource)
        resource_path = resource_data.path
        binary = str(resource_path / 'log_preprocessor' / 'bin' / 'log_preprocessor')

        command = [binary]
        command.append('--actor')
        command.append('LogPreprocessor')
        command.append('--component')
        command.append(self.Parameters.component_parameter)
        command.append('--period')
        command.append('Day')
        command.append('--check-freshness')
        command.append('True')

        with sdk2.helpers.ProcessLog(self, logger="log_preprocessor") as pl:
            pl.logger.propagate = 1
            my_env = os.environ.copy()
            my_env['ENV_TYPE'] = 'production'
            my_env['YT_TOKEN'] = sdk2.yav.Secret("sec-01dh94knca8ad1gha9cypwq42s").data()["YT_TOKEN"]
            my_env['YT_POOL'] = YT_POOL
            if sp.Popen(command, shell=False, env=my_env, stdout=pl.stdout, stderr=sp.STDOUT).wait() != 0:
                raise TaskFailure('log_preprocessor exited with error. See logs for details.')
