import os

import sandbox.common.types.resource as ctr
import sandbox.common.types.task as ctt

from sandbox import sdk2
from sandbox.common.errors import TaskFailure, TaskStop

class MapsStatisticsLogPreprocessorV2Dummy(sdk2.Task, object):
    fail_on_any_error = True

    class Requirements(sdk2.Requirements):
        cores = 1  # 1 cores or less
        ram = 8192  # 8GiB or less

        class Caches(sdk2.Requirements.Caches):
            pass  # means that task do not use any shared caches


    class Parameters(sdk2.Parameters):
        date_parameter = sdk2.parameters.String("Date", required=True)
        with sdk2.parameters.String("Component", multiline=True, default='navigator') as component_parameter:
            component_parameter.values['navigator'] = 'navigator'
            component_parameter.values['maps'] = 'maps'
            component_parameter.values['auto'] = 'auto'
        with sdk2.parameters.String("Environment", multiline=True, default='testing') as env_parameter:
            env_parameter.values['testing'] = 'testing'
            env_parameter.values['production'] = 'production'
        force_parameter = sdk2.parameters.Bool("Force recalculate", default=False)
        fail_parameter = sdk2.parameters.Bool("Fail on exit", default=False)


    def on_execute(self):
        if self.Parameters.fail_parameter:
            raise TaskFailure('log_preprocessor exited with error. See logs for details.')
