from sandbox import sdk2

from resource_types import *  # noqa

from sandbox.projects.maps.common.juggler_alerts import (
    TaskJugglerReportWithParameters
)


class MapsStreetviewPoiPipelineParams(TaskJugglerReportWithParameters.Parameters):
    owner = 'MAPS'
    kill_timeout = 72 * 60 * 60  # 72 hours

    with sdk2.parameters.Group('Tokens') as vault_token:
        yql_token = sdk2.parameters.Vault(
            'yql token vault',
            required=True
        )
        yt_token = sdk2.parameters.Vault(
            'yt token vault',
            required=True
        )
        toloka_token = sdk2.parameters.Vault(
            'toloka token vault',
            required=True
        )
        sandbox_toloka_token = sdk2.parameters.Vault(
            'sandbox.toloka token vault',
            required=True
        )
        aws_access_key_id = sdk2.parameters.Vault(
            'aws access key id vault',
            required=True,
        )
        aws_secret_access_key = sdk2.parameters.Vault(
            'aws secret access key vault',
            required=True,
        )

    with sdk2.parameters.Group('Executables') as executables:
        bld_orgs_binary = sdk2.parameters.Resource(
            'Sandbox resource ID for bld_orgs binary',
            resource_type=MapsStreetviewPoiBldOrgsBinary,
            required=True
        )
        pano_id_generation_binary = sdk2.parameters.Resource(
            'Sandbox resource ID for pano_id_generation binary',
            resource_type=MapsStreetviewPoiPanoIdGenerationBinary,
            required=True
        )
        preview_creator_binary = sdk2.parameters.Resource(
            'Sandbox resource ID for preview_creator binary',
            resource_type=MapsStreetviewPoiPreviewCreatorBinary,
            required=True
        )
        toloka_tool_binary = sdk2.parameters.Resource(
            'Sandbox resource ID for toloka_tool binary',
            resource_type=MapsStreetviewPoiTolokaToolBinary,
            required=True
        )
        make_pretty_result_binary = sdk2.parameters.Resource(
            'Sandbox resource ID for make_pretty_result binary',
            resource_type=MapsStreetviewPoiMakePrettyResultBinary,
            required=True
        )

    with sdk2.parameters.Group('Main settings') as main_settings:
        yt_root_path = sdk2.parameters.String(
            'YT root path',
            required=True,
            description='Path to root YT folder where all data will be saved'
        )
        force_suffix = sdk2.parameters.String(
            'Override datetime suffix',
            required=False,
            description='This value will override datetime suffix'
        )
        notification_recipients = sdk2.parameters.List(
            'notification recipients',
            default=['kremius', 'tswr']
        )
        markup_permalinks = sdk2.parameters.String(
            'markup permalinks table',
            required=True,
            description='YT table with needed permalinks'
        )
        max_panoramas_age_days = sdk2.parameters.Integer(
            'Max panoramas age days',
            default=180,
        )
        ymapsdf_folder = sdk2.parameters.String(
            'ymapsdf folder',
            default='//home/maps/core/garden/stable/ymapsdf/latest/cis1',
        )
        check_toloka_status_period = sdk2.parameters.Integer(
            'update toloka tasks status period (seconds)',
            default=30 * 60,
        )
        use_production_toloka = sdk2.parameters.Bool(
            'use production toloka',
            default=False,
        )
        max_dollar_spendings = sdk2.parameters.Float(
            'maximum spending per pool, task will stop if the limit is reached',
            default=50.0,
        )
        sample_golden_set = sdk2.parameters.Bool(
            'sample golden set from existing data',
            default=False,
        )
        with sample_golden_set.value[True]:
            first_task_gs_table = sdk2.parameters.String(
                'first task golden set table',
                required=True,
            )
            second_task_gs_table = sdk2.parameters.String(
                'second task golden set table',
                required=True
            )
            third_task_gs_table = sdk2.parameters.String(
                'third task golden set table',
                required=True
            )
        with sample_golden_set.value[False]:
            public_url_format = sdk2.parameters.Bool(
                'store golden set tasks in public bucket',
                default=False,
                description='set when golden set markup is produced by cartographers'
            )

        create_new_toloka_projects = sdk2.parameters.Bool(
            'create new toloka projects for each task',
            default=True,
        )
        with create_new_toloka_projects.value[False]:
            first_task_proj_id = sdk2.parameters.Integer(
                'toloka first task project id',
                required=True,
            )
            second_task_proj_id = sdk2.parameters.Integer(
                'toloka second task project id',
                required=True,
            )
            third_task_proj_id = sdk2.parameters.Integer(
                'toloka third task project id',
                required=True,
            )
            with sample_golden_set.value[False]:
                first_task_proj_id_sb = sdk2.parameters.Integer(
                    'sandbox toloka first task project id',
                    required=True,
                )
                second_task_proj_id_sb = sdk2.parameters.Integer(
                    'sandbox toloka second task project id',
                    required=True,
                )
                third_task_proj_id_sb = sdk2.parameters.Integer(
                    'sandbox toloka third task project id',
                    required=True,
                )
