import os

from sandbox import sandboxsdk
from sandbox.projects.common.build import YaPackage
from sandbox.sandboxsdk.parameters import SandboxStringParameter


class MultiplePublishMappingParameter(sandboxsdk.parameters.DictRepeater, sandboxsdk.parameters.SandboxStringParameter):
    name = 'maps_publish_to_mapping'
    description = "Package name -> repos ';' separated"
    default_value = None


class ChangelogParameter(SandboxStringParameter):
    name = 'maps_changelog'
    description = 'Path to arcadia changelog file. Would try /path/to/pkg.json/../debian/changelog'
    required = False
    default_value = ''


class MapsYaPackage(YaPackage.YaPackage, object):
    """
        Like YaPackage, but you don't need to remember that zillions of knobs.
        Builds package from pkg.json located in arcadia/maps/packages and uploads them
    """

    type = 'MAPS_YA_PACKAGE'

    input_parameters = [
        MultiplePublishMappingParameter,
        ChangelogParameter,
        YaPackage.parameters.ArcadiaUrl,
    ]

    def on_enqueue(self):
        self._setup_parameters()
        super(MapsYaPackage, self).on_enqueue()

    def on_prepare(self):
        self._setup_parameters()

    def _setup_parameters(self):
        def pkg_json_path(package):
            return 'maps/packages/{}/pkg.json'.format(package)

        self.ctx[YaPackage.parameters.BuildType.name] = YaPackage.RELEASE
        self.ctx[YaPackage.PackageTypeParameter.name] = YaPackage.DEBIAN
        packages = self.ctx[MultiplePublishMappingParameter.name].keys()
        self.ctx[YaPackage.PackagesParameter.name] = ';'.join(map(pkg_json_path, packages))
        self.ctx[YaPackage.CompressPackageArchiveParameter.name] = True
        self.ctx[YaPackage.DuploadMaxAttemptsParameter.name] = 3
        self.ctx[YaPackage.ResourceTypeParameter.name] = 'YA_PACKAGE'
        default_changelog = os.path.join(self.ctx[YaPackage.PackagesParameter.name], '../debian/changelog')
        self.ctx[YaPackage.ChangelogParameter.name] = self.ctx.get(ChangelogParameter.name) or default_changelog
        self.ctx[YaPackage.PublishPackageParameter.name] = True
        self.ctx[YaPackage.MultiplePublishParameter.name] = True
        self.ctx[YaPackage.MultiplePublishToParameter.name] = ''
        self.ctx[YaPackage.MultiplePublishMappingParameter.name] = {
            pkg_json_path(pkg): repos for pkg, repos in self.ctx[MultiplePublishMappingParameter.name].iteritems()}
