from sandbox import sdk2

from sandbox.common.errors import TemporaryError, TaskFailure

import subprocess

ST_TOKEN_OWNER = "MAPS"
ST_TOKEN_NAME = "STARTREK_TOKEN"


class MapsStartrekToolV1(sdk2.Task):

    class Requirements(sdk2.Requirements):
        cores = 1

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(sdk2.Parameters):
        startrek_queue = sdk2.parameters.String('Starttreck queue name')
        startrek_tool = sdk2.parameters.Resource('Starttreck tool resource id', required=True)
        filter_backlog = sdk2.parameters.Bool('Filter backlog tasks', default=True)
        filter_epics = sdk2.parameters.Bool('Filter epics', default=True)
        filter_empty = sdk2.parameters.Bool('Skip empty deadlines', default=False)

    def on_execute(self):
        # Set up the common environment.
        st_queue = self.Parameters.startrek_queue
        filter_backlog = self.Parameters.filter_backlog
        filter_epics = self.Parameters.filter_epics
        filter_empty = self.Parameters.filter_empty

        st_tool = sdk2.ResourceData(self.Parameters.startrek_tool)

        st_token = sdk2.Vault.data(ST_TOKEN_OWNER, ST_TOKEN_NAME)
        print st_token

        binary_path = st_tool.path  # ya upload case for development
        if not binary_path.is_file():
            binary_path = binary_path.joinpath('bin/startrek_tool')  # YA_MAKE case

        params = [str(binary_path), '--auth_token', st_token, 'comment_expired_tasks', '--queue', st_queue]

        if filter_backlog:
            params.append("--filter-backlog")

        if filter_epics:
            params.append("--filter-epics")

        if filter_empty:
            params.append("--filter-empty")

        self._run_binary(params)

    def _run_binary(self, run_list):
        try:
            output = subprocess.check_output(run_list, stderr=subprocess.STDOUT)
            self.set_info(output)
        except subprocess.CalledProcessError, e:
            error_str = 'exitcode: {code}, output: {output}'.format(
                code=e.returncode, output=e.output)
            RETRIABLE_EXITCODE = 1
            if e.returncode == RETRIABLE_EXITCODE:
                raise TemporaryError(error_str)
            else:
                raise TaskFailure(error_str)
