import os
import subprocess

from datetime import datetime

import sandbox.common.types.client as ctc

from sandbox import sdk2
from sandbox.common.errors import TaskFailure
from sandbox.projects.maps.common.ecstatic_bin import MapsEcstaticToolMixin


DATASET_NAME = 'yandex-maps-ecstatic-debug-dataset'
TVM_ID = 2017335
TVM_SECRET_ID = 'sec-01dvr0te5mzba4mmape5ra8c5s'


class UploadEcstaticDebugDataset(MapsEcstaticToolMixin, sdk2.Task):
    """Packs several sandbox resources into one ecstatic dataset"""
    class Requirements(sdk2.Task.Requirements):
        ram = 50 << 10  # 50 GB
        disk_space = 120 << 10
        client_tags = ctc.Tag.SSD

    class Parameters(sdk2.Task.Parameters):
        owner = 'MAPS'
        environments = sdk2.parameters.List('Ecstatic environments', default=['testing'])
        dataset_size = sdk2.parameters.Integer('Dataset size, GB, <= 70', default=50)
        ecstatic_bin_resource = sdk2.parameters.String('Ecstatic tool binary sandbox resource ID', required=True,
                                                       default=MapsEcstaticToolMixin.DEFAULT_BINARY_RESOURCE_ID)
        libtorrent_options = sdk2.parameters.Dict('Libtorrent options. Use `true/false` for flag options')
        debug_ymtorrent = sdk2.parameters.Bool('Debug-ymtorrent', default=False)

    def on_execute(self):
        os.mkdir('dataset')

        with open('dataset/file', 'wb') as fout:
            data = os.urandom(1 << 28)
            for _ in range(int(self.Parameters.dataset_size) << 2):
                fout.write(data)

        version = datetime.strftime(datetime.today(), '%Y-%m-%d-%H-%M-%S')
        MapsEcstaticToolMixin.debug_ymtorrent = self.Parameters.debug_ymtorrent
        try:
            for environment in self.Parameters.environments:
                self.ecstatic(
                    environment=environment,
                    do_auth=True,
                    cmd_args=['upload', '{}={}'.format(DATASET_NAME, version), 'dataset', '+stable'],
                    resource_id=self.Parameters.ecstatic_bin_resource,
                    libtorrent_options=self.Parameters.libtorrent_options, tvm_id = TVM_ID, tvm_secret_id = TVM_SECRET_ID)
        except subprocess.CalledProcessError as e:
            self.set_info(e.output)
            raise TaskFailure('Ecstatic returned ' + str(e.returncode))

