import os
import subprocess
import shutil

from sandbox import sdk2
from sandbox.common.errors import TaskFailure

from sandbox.projects.maps.common.ecstatic_bin import MapsEcstaticToolMixin


TVM_IDS = {
    'testing': 2018420,
    'stable': 2018422,
}
TVM_SEC_UUIDS = {
    'testing': 'sec-01e0q9xznk7j2qjd196w49drf3',
    'stable': 'sec-01e0q9z2q3wk1fbhzx7cek4kvb',
}


class WHOLE_TRACK_MODEL_RESOURCE(sdk2.Resource):
    """
        Whole Track Model Resource Type
    """


class WHOLE_TRACK_MODEL_TASK(MapsEcstaticToolMixin, sdk2.Task):
    """ Uploads resource from Sandbox to Ecstatic. """
    class Requirements(sdk2.Requirements):
        cores = 1

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(sdk2.Parameters):
        model_resource_id = sdk2.parameters.String('Catboost model Sandbox resource ID', default='643287152')
        config_resource_id = sdk2.parameters.String('Model config Sandbox resource ID', default='891322544')
        dataset = sdk2.parameters.String('Ecstatic dataset name')
        version = sdk2.parameters.String('Ecstatic dataset version')
        filename = sdk2.parameters.String('Model target file name', default='matrixnet.3.info')
        config_filename = sdk2.parameters.String('Config target file name', default='matrixnet.meta')
        environment = sdk2.parameters.String('Ecstatic environment')

    def on_execute(self):
        model_resource = sdk2.Resource[self.Parameters.model_resource_id]
        model_resource_data = sdk2.ResourceData(model_resource)

        config_resource = sdk2.Resource[self.Parameters.config_resource_id]
        config_resource_data = sdk2.ResourceData(config_resource)

        os.makedirs('data')
        shutil.copy(str(model_resource_data.path), './data/{}'.format(self.Parameters.filename))
        shutil.copy(str(config_resource_data.path), './data/{}'.format(self.Parameters.config_filename))

        try:
            self.ecstatic(
                self.Parameters.environment,
                [
                    'upload',
                    self.Parameters.dataset + '=' + self.Parameters.version,
                    'data', '+stable'
                ],
                tvm_id=TVM_IDS.get(self.Parameters.environment),
                tvm_secret_id=TVM_SEC_UUIDS.get(self.Parameters.environment),
            )
        except subprocess.CalledProcessError as e:
            self.set_info(e.output)
            raise TaskFailure('Ecstatic returned ' + str(e.returncode))
