from sandbox import sdk2
from sandbox.common.errors import TaskError
from sandbox.projects.maps.automotive.store.task import MapsAutoStoreTask
from sandbox.sdk2.helpers import subprocess as sp
import logging
import sandbox.common.types.client as ctc


class MapsAutoStoreExport(MapsAutoStoreTask):
    """
    Exports internal store Postgres data to YT
    """

    class Requirements(MapsAutoStoreTask.Requirements):
        client_tags = ctc.Tag.LINUX_XENIAL

    def on_prepare(self):
        resource = sdk2.Resource["PG_TO_YT_EXECUTABLE"].find()
        if resource.count > 0:
            res = resource.first()
            binary = sdk2.ResourceData(res)
            self.Context.pg_to_yt = str(binary.path)
            self.Context.save()
        else:
            raise TaskError("PG_TO_YT_EXECUTABLE not found")

    def on_execute(self):
        self.init()

        db_name = "store-internal"
        db_user = "store_internal"
        if (self.Parameters.environment == "testing"):
            db_host = "vla-v0qsce3qro9vevl9.db.yandex.net"
            db_password = self.secret["store_mdbt_password"]
        else:
            db_host = "vla-2b4h89vgp2c2e5em.db.yandex.net"
            db_password = self.secret["store_mdb_password"]
        db_tables = [
            "vyt_package",
            "vyt_package_rollout",
            "vyt_package_dependency",
            "vyt_firmware",
            "vyt_firmware_rollout",
            "vyt_firmware_feature",
            "vyt_rollout_experiment",
            "vyt_headunit_type",
            "vyt_headunit_mcu",
            "vyt_headunit_model",
            "vyt_app",
            "vyt_app_tag",
            "vyt_headunit",
            "vyt_headunit_packages",
            "vyt_headunit_attrs",
            "vyt_headunit_stat",
            "vyt_package_rollout_stat"
        ]

        cmd = [self.Context.pg_to_yt]
        cmd.extend(["-db-host", db_host])
        cmd.extend(["-db-name", db_name])
        cmd.extend(["-db-user", db_user])
        cmd.extend(["-db-password", db_password])
        cmd.extend(["-yt-cluster", self.yt_cluster])
        cmd.extend(["-yt-path", self.yt_path])
        cmd.extend(["-yt-token", self.secret["YT_TOKEN"]])
        for table in db_tables:
            cmd.extend(["-db-table", table])

        with sdk2.helpers.ProcessLog(self, logger="pg_to_yt") as pl:
            if sp.Popen(cmd, stdout=pl.stdout, stderr=sp.STDOUT).wait() != 0:
                raise TaskError("pg_to_yt failed")

        with self.yt.Transaction():
            for table in db_tables:
                new_name = table.replace("vyt_", "", 1)
                self.yt.move(
                    self.yt_path + "/" + table,
                    self.yt_path + "/" + new_name,
                    force=True)
