from sandbox import sdk2
from sandbox.projects.maps.common.juggler_alerts import TaskJugglerReportWithParameters
from sandbox.sandboxsdk.environments import PipEnvironment
from sandbox.sdk2 import yav


class MapsAutoStoreTask(TaskJugglerReportWithParameters):
    """
    Base abstract task for internal store jobs
    """

    class Requirements(sdk2.Requirements):
        environments = [
            PipEnvironment("yql"),
            PipEnvironment("yandex-yt"),
            PipEnvironment("yandex-yt-yson-bindings-skynet"),
        ]

    class Parameters(TaskJugglerReportWithParameters.Parameters):

        environment = sdk2.parameters.String(
            "Environment",
            choices=list((v, v) for v in ['testing', 'stable']),
            default_value='testing',
            required=True
        )

    def on_save(self):
        if not self.Parameters.juggler_host_name:
            self.Parameters.juggler_host_name = 'sandbox.{task}.{env}'.format(
                task=self.type, env=self.Parameters.environment)
        if not self.Parameters.juggler_service_name:
            self.Parameters.juggler_service_name = 'successful_run'

    def init(self):
        from yt.wrapper import YtClient
        from yql.api.v1.client import YqlClient

        self.secret = yav.Secret("sec-01d54vrz0f6k6vqjadm4kmbgsr").data()
        self.yt_cluster = "hahn"
        self.yt_path = "//home/maps/automotive/store_internal/{}/postgres".format(self.Parameters.environment)
        self.yt = YtClient(proxy=self.yt_cluster, token=self.secret["YT_TOKEN"])
        self.yql = YqlClient(db=self.yt_cluster, token=self.secret["YQL_TOKEN"])

        if (self.Parameters.environment == "testing"):
            self.store_url = "http://auto-store-internal.testing.maps.n.yandex.ru"
        else:
            self.store_url = "http://auto-store-internal.maps.yandex.net"
