import datetime

from sandbox import sdk2

from sandbox.projects.maps.MapsBinaryTask import MapsBinaryTask
import sandbox.projects.resource_types.releasers as releasers


class YaCourierExportToYt(MapsBinaryTask):
    """
    Export data from ycb db to yt
    """
    releasers = releasers.b2bgeo_releasers

    class Parameters(MapsBinaryTask.Parameters):
        days_delay = sdk2.parameters.Integer(
            'Delay between today and exported date',
            default_value=30
        )

    def on_execute(self):
        date_to_export = (datetime.date.today() - datetime.timedelta(days=self.Parameters.days_delay)).isoformat()
        arguments = self.Parameters.args + ['--date-from', date_to_export, '--date-to', date_to_export]

        # Can't modify self.Parameters.args, because it's immutable. So next part is copied from MapsBinaryTask
        # https://a.yandex-team.ru/arc/trunk/arcadia/sandbox/projects/maps/MapsBinaryTask/__init__.py?rev=r8085120#L24
        options = self.options_from_vault(self.Parameters.vault_options)
        options.update(self.Parameters.options)
        arcadia_context = self.empty_context()
        if self.Parameters.mount_arcadia:
            arcadia_context = self.mount_arcadia()
        env_options = self.options_from_vault(self.Parameters.vault_env_options)
        env_options.update(self.Parameters.env_options)
        with arcadia_context as arcadia:
            self.run_binary(
                options=self.convert_empty_to_true(options),
                arguments=arguments,
                subcmd=self.Parameters.subcmd,
                subcmd_options=self.Parameters.subcmd_options,
                env_options=env_options,
                cwd=arcadia,
            )
