from sandbox import sdk2
from sandbox.projects.maps.common.docker_utils import get_image_hash
from sandbox.projects.maps.b2bgeo.ci.common.BbgeoComponentAutoDeploy import BbgeoComponentAutoDeploy


class BbgeoSolverAutoDeploy(BbgeoComponentAutoDeploy):
    type = "BBGEO_SOLVER_AUTO_DEPLOY"

    input_parameters = [
        BbgeoComponentAutoDeploy.ContainerParameter,
        BbgeoComponentAutoDeploy.Revision
    ]

    def on_prepare(self):
        revision = self.ctx[self.Revision.name]

        self.ctx[self.DockerPackageJsonParameter.name] = \
            'maps/b2bgeo/ya_courier/solver/docker/solver-build/maps-b2bgeo-solver.json'
        self.ctx[self.RegistryTags.name] = \
            ["registry.yandex.net/b2bgeo/solver-backend:{}".format(revision)]
        self.ctx[self.QloudEnvironmentId.name] = \
            'b2bgeo.ya-courier.solver-dev'

        BbgeoComponentAutoDeploy.on_prepare(self)

    def on_execute(self):
        revision = self.ctx[self.Revision.name]

        with self.memoize_stage.execute_component_auto_deploy_task:
            BbgeoComponentAutoDeploy.on_execute(self)

        with self.memoize_stage.documentation_deploy:
            self.ctx['child_tasks'] = {}

            doc_deploy_task_class = sdk2.Task["BBGEO_DOCUMENTATION_DEPLOY"]
            doc_deploy_task = doc_deploy_task_class(
                doc_deploy_task_class.current,
                description="Deploy VRP API public documentation to testing, revision {}".format(revision),
                owner=self.owner,
                priority=self.priority,
                build_vrs=True,
                svn_rev_vrp=revision).enqueue()
            self.ctx['child_tasks']['documentation_deploy'] = doc_deploy_task.id

            self.wait_all_tasks_stop_executing(self.ctx['child_tasks'].values())

        self.check_successful_subtasks_finish()

    def update_component_env(self, env):
        image_name = self.ctx.get(self.RegistryTags.name)[0]

        for component in env["components"]:
            name = component["componentName"]
            if name in ["solver-balancer"]:
                properties = component["properties"]
                properties["repository"] = image_name
                properties["hash"] = get_image_hash(image_name, self.docker_cmd)
        env["comment"] = self.description + "\n" + "Image: " + image_name
