import logging
import os
from sandbox import sdk2
from sandbox.sdk2.helpers import subprocess as sp
import sandbox.common.types.client as ctc
import sandbox.common.types.misc as ctm


_MOBILE_TOKEN_VAULT_TESTING_SUPER_USER = 'b2bgeo_ya_courier_backend_courier_app_token_super_user'
_MOBILE_TOKEN_VAULT_TESTING_APP_USER = 'b2bgeo_ya_courier_backend_courier_app_token'
_MOBILE_TOKEN_VAULT_TESTING_APP_UNREGISTERED_USER = 'b2bgeo_ya_courier_backend_courier_app_token_unregistered_user'


class BbgeoYaCourierApplicationTests(sdk2.Task):
    '''
    Run Ya-Courier Backend application tests
    '''
    class Requirements(sdk2.Task.Requirements):
        # NPM has troubles with IPv6.
        dns = ctm.DnsType.DNS64

    class Parameters(sdk2.Task.Parameters):
        container = sdk2.parameters.Container(
            'Environment container resource',
            required=True,
            default_value='3108181866'
        )

        kill_timeout = 60 * 60  # 60 minutes

    def on_execute(self):
        with sdk2.helpers.ProcessLog(self, logger=logging.getLogger("ya-courier-app-test")) as process_log:
            sp.check_call("git clone https://github.yandex-team.ru/B2BGeo/frontend.git",
                          shell=True, stdout=process_log.stdout, stderr=process_log.stdout)

            os.chdir("frontend")

            # npm ERR! Maximum call stack size exceeded
            # https://stackoverflow.com/a/55551732
            sp.check_call("rm -f package-lock.json",
                          shell=True, stdout=process_log.stdout, stderr=process_log.stdout)

            sp.check_call("npm i --loglevel verbose",
                          shell=True, stdout=process_log.stdout, stderr=process_log.stdout)

            sp.check_call("npm run bootstrap",
                          shell=True, stdout=process_log.stdout, stderr=process_log.stdout)

            os.chdir("projects/courier-app")

            sp.check_call("npm i --loglevel verbose",
                          shell=True, stdout=process_log.stdout, stderr=process_log.stdout)

            super_user_token = sdk2.Vault.data(
                _MOBILE_TOKEN_VAULT_TESTING_SUPER_USER)
            app_user_token = sdk2.Vault.data(
                _MOBILE_TOKEN_VAULT_TESTING_APP_USER)
            unregistered_user_token = sdk2.Vault.data(
                _MOBILE_TOKEN_VAULT_TESTING_APP_UNREGISTERED_USER
            )

            command = "SUPER_USER_TOKEN={} " \
                      "APP_USER_TOKEN={} " \
                      "UNREGISTERED_USER_TOKEN={} " \
                      "CONFIG=testing " \
                      "npm run api-tests" \
                      .format(super_user_token, app_user_token, unregistered_user_token)

            sp.check_call(command, shell=True, stdout=process_log.stdout, stderr=process_log.stdout)
