from sandbox import sandboxsdk, sdk2, common
from sandbox.sandboxsdk.errors import SandboxTaskFailureError
import sandbox.projects.common.build.parameters as build_params
import sandbox.common.types.task as ctt

from sandbox.projects.maps.common.qloud_client import update_qloud_environment
from sandbox.projects.common.build import YaPackage
from sandbox.projects.BuildDockerImageV6 import BuildDockerImageV6


QLOUD_TOKEN_VAULT = 'robot_b2bgeo_qloud_token'


class BbgeoComponentAutoDeploy(BuildDockerImageV6):
    class QloudEnvironmentId(sandboxsdk.parameters.SandboxStringParameter):
        name = "qloud_environment_id"
        description = "Id of B2bSolver environment where to push new image"
        required = True
        group = "Qloud deployment"

    class Revision(sandboxsdk.parameters.SandboxStringParameter):
        name = "revision"
        description = "Revision of arcadia for the component"
        required = True
        group = "Qloud deployment"

    type = "BBGEO_COMPONENT_AUTO_DEPLOY"

    input_parameters = [
        BuildDockerImageV6.ContainerParameter,
        BuildDockerImageV6.ArcadiaUrl,
        BuildDockerImageV6.RegistryTags,
        BuildDockerImageV6.DockerPackageJsonParameter,
        QloudEnvironmentId,
        Revision
    ]

    def update_component_env(self, env):
        """
        Updates Qloud env dict that should be pushed
        to the specified QloudEnvironmentId

        Args:
            * env - source Qloud environment dict - just modify it correspondently
        """
        raise RuntimeError('Not implemented')

    def on_prepare(self):
        self.ctx[self.PackagedResource.name] = None
        self.ctx[self.ArcadiaPatch.name] = ''
        self.ctx[build_params.BuildType.name] = YaPackage.RELEASE
        self.ctx[self.DockerSetupScript.name] = self.DockerSetupScript.default_value
        self.ctx[self.DockerfileUrl.name] = None
        self.ctx[self.ResourceType.name] = 'directory'
        self.ctx[self.RegistryLogin.name] = 'robot-b2bgeo'
        self.ctx[self.VaultItemName.name] = 'robot_b2bgeo_docker_token'
        self.ctx[self.VaultItemOwner.name] = 'B2BGEO-DEV'

        revision = self.ctx[self.Revision.name]
        self.ctx[self.ArcadiaUrl.name] = \
            'arcadia:/arc/trunk/arcadia@{}'.format(revision)

        assert len(self.ctx.get(self.RegistryTags.name)) == 1, \
            "Only one tag is supported in autodeploy task"
        if "qloud_timeouts" not in self.__dict__:
            self.qloud_timeouts = None
        BuildDockerImageV6.on_prepare(self)

    def on_execute(self):
        qloud_environment = self.ctx.get(self.QloudEnvironmentId.name)
        qloud_token = self.get_vault_data(QLOUD_TOKEN_VAULT)

        BuildDockerImageV6.on_execute(self)
        try:
            update_qloud_environment(
                qloud_environment,
                qloud_token,
                self.update_component_env,
                "bbgeo-bugs@yandex-team.ru",
                self.qloud_timeouts)
        except RuntimeError as e:
            raise SandboxTaskFailureError("Failed to update image in qloud: {}".format(e))

    def check_successful_subtasks_finish(self):
        for task_name in self.ctx['child_tasks']:
            task = sdk2.Task[self.ctx['child_tasks'][task_name]]
            if task.status != ctt.Status.SUCCESS:
                raise common.errors.TaskFailure("{} task failed with status {}".format(task_name, task.status))
