import base64
import hashlib
import hmac
import logging
import urllib
import urlparse


class YaCourierDeepLinkDecoder:

    def __init__(self, key):
        assert key is None or isinstance(key, bytes)
        self.key = key

    def decode(self, yacourier):
        decoded = base64.urlsafe_b64decode(urllib.unquote(yacourier))
        if self.key is None:
            logging.debug('Ignore signature')
            params = urlparse.parse_qs(decoded, keep_blank_values=True)
        else:
            signaturePosition = decoded.find('&signature=')
            if signaturePosition < 0:
                raise RuntimeError('No signature in yacourier string')
            signedPart = decoded[0:signaturePosition]
            signatureStart = signaturePosition + len('&signature=')
            parsedSignature = decoded[signatureStart:]
            logging.debug('signedPart {}'.format(signedPart))
            logging.debug('signature received {}'.format(parsedSignature))
            signature = hmac.new(self.key, signedPart, hashlib.sha256).hexdigest()
            logging.debug('signature calculated {}'.format(signature))
            if signature != parsedSignature:
                raise RuntimeError('signature is not valid')
            params = urlparse.parse_qs(signedPart, keep_blank_values=True)

        return {key: value[0] for key, value in params.iteritems()}
