import os

from sandbox.sandboxsdk import environments
from sandbox import sdk2


_LATEST_NODE_MARKER = "/LATEST"


class MapsCarparksBaseTask(sdk2.Task):
    class Requirements(sdk2.Task.Requirements):
        environments = (
            environments.PipEnvironment('yandex-yt'),
        )

        cores = 1  # exactly 1 core
        ram = 1024  # 1GiB or less

        class Caches(sdk2.Requirements.Caches):
            pass  # means that task do not use any shared caches

    class Parameters(sdk2.Task.Parameters):
        vault_owner = sdk2.parameters.String(
            'Sandbox Vault owner',
            required=True,
            default='robot-maps-carparks'
        )
        yt_token_vault_name = sdk2.parameters.String(
            'YT token Sandbox Vault name',
            required=True,
            default='YT_TOKEN'
        )

    _yt = None

    def _yt_token(self):
        return sdk2.Vault.data(self.Parameters.vault_owner,
                               self.Parameters.yt_token_vault_name)

    @property
    def yt(self):
        if self._yt:
            return self._yt

        # yt.wrapper package is only available during on_execute
        import yt.wrapper as yt
        yt.config["token"] = self._yt_token()
        yt.config['proxy']['url'] = "hahn.yt.yandex.net"

        self._yt = yt
        return self._yt

    def prepare_yt_token(self):
        os.environ["YT_TOKEN"] = self._yt_token()

    def get_latest_node(self, path):
        nodes = sorted(self.yt.list(path))
        if not nodes:
            return None

        return path + "/" + nodes[-1]

    def get_specific_node_or_latest(self, path):
        if path.endswith(_LATEST_NODE_MARKER):
            return self.get_latest_node(path[:-len(_LATEST_NODE_MARKER)])
        return path
