import os
import logging

from sandbox import sdk2
from sandbox.sdk2.helpers import ProcessLog, subprocess as sp
from sandbox.sdk2.vcs.svn import Arcadia


def run(resource_with_binary, *args):
    binary = str(sdk2.ResourceData(resource_with_binary).path)

    cmd = [binary]
    cmd.extend(args)

    with ProcessLog(logger=logging.getLogger(os.path.basename(binary))) as pl:
        sp.check_call(cmd,
                      stdout=pl.stdout,
                      stderr=pl.stdout)


def get_file_from_arcadia(path):
    path, basename = os.path.split(path)
    checkout_path = Arcadia.get_arcadia_src_dir(path)
    return checkout_path + '/' + basename

