from sandbox import sdk2
from sandbox.projects.maps.common.resource_types import front_team_releasers, front_robot_releasers


class BaseMapsConfigHostsResource(sdk2.Resource):
    """
        Common host config for geosearch projects
    """
    any_arch = True
    executable = False
    releasable = True
    releasers = front_team_releasers + front_robot_releasers
    release_subscribers = ['sigorilla']

    # Custom attribute
    version = sdk2.parameters.String('Version of package', required=True)


class MapsEcstaticToolBinaryResource(sdk2.Resource):
    """Resource for ecstatic tool & ymtorrent"""

    executable = True
    any_arch = False
    releasable = True
    releasers = ['MAPS_GEOINFRA']
    release_subscribers = ['geo-infra-notifications']


class MapsEcstaticDatasetResource(sdk2.Resource):
    """Common resource for ecstatic datasets"""

    releasable = True
    executable = False

    # Custom attributes
    dataset = sdk2.parameters.String('Name of dataset (with tag)', required=True)
    version = sdk2.parameters.String('Version of dataset', required=True)
