from sandbox import sdk2


class MapsCoreBaseResource(sdk2.Resource):
    """Common data resource for mapscore projects"""
    sandbox_task_id = sdk2.Attributes.String('Sandbox task ID', required=True)
    sandbox_task_type = sdk2.Attributes.String('Sandbox task type', required=True)
    sandbox_task_owner = sdk2.Attributes.String('Sandbox task owner', required=True)
    arcadia_revision = sdk2.Attributes.String('Arcadia revision', required=True)
    version = sdk2.Attributes.String('Resource version', required=True)


class MapsCoreCoverageResource(MapsCoreBaseResource):
    """Maps coverage resource"""
    releasable = True
    auto_backup = True
    ttl = 'inf'
