# -*- coding: utf-8 -*-

import logging

from sandbox import sdk2
from sandbox.projects.common import binary_task


class FacebookAudienceLoader(binary_task.LastBinaryTaskRelease, sdk2.Task):
    class Parameters(sdk2.Parameters):
        _last_binary_release_parameters = binary_task.binary_release_parameters(stable=True)
        with sdk2.parameters.Group("Import from YT parameters") as yt_params:
            yt_table = sdk2.parameters.String("YT table", required=True)
            cluster = sdk2.parameters.String("Cluster", required=True, default_value="hahn")
            secret_yt_token = sdk2.parameters.YavSecret("YT token", required=True)

        with sdk2.parameters.Group("Facebook ads parameters") as facebook_params:
            facebook_account_id = sdk2.parameters.String("Facebook account ID", default_value="act_1832055007097855", required=True)
            secret_facebook_token = sdk2.parameters.YavSecret("Facebook token", required=True)

        with sdk2.parameters.Group("Segment parameters") as segment_params:
            segment_name = sdk2.parameters.String("Segment name", default_value="name", required=True)
            segment_description = sdk2.parameters.String("Segment description", default_value="description", required=True)
            with sdk2.parameters.String("ID Type", required=True) as id_type:
                id_type.values["mobile_advertiser_id"] = "mobileId"
                id_type.values["phone_hash"] = "hashedPhoneNumber"
                id_type.values["email_hash"] = "hashedEmail"

        with sdk2.parameters.String("Operator", required=True) as operator:
            operator.values["ADD"] = "ADD"
            operator.values["REMOVE"] = "REMOVE"

    def on_execute(self):
        import sandbox.projects.maps.geomarketing.FacebookAudienceLoader.src.audience_reader as audience_reader
        import sandbox.projects.maps.geomarketing.FacebookAudienceLoader.src.audience_loader as audience_loader

        yt_token = self.Parameters.secret_yt_token.data()["nirvana-secret"]
        facebook_token = self.Parameters.secret_facebook_token.data()["token"]

        yt_table = str(self.Parameters.yt_table)
        cluster = str(self.Parameters.cluster)
        facebook_account_id = str(self.Parameters.facebook_account_id)
        segment_name = str(self.Parameters.segment_name)
        segment_description = str(self.Parameters.segment_description)
        id_type = str(self.Parameters.id_type)
        operator = str(self.Parameters.operator)

        audience_from_yt = audience_reader.get_audience_from_yt(
            yt_input_table=yt_table,
            yt_token=yt_token,
            cluster=cluster,
            id_type=id_type
        )

        facebook_audience = audience_loader.create_facebook_audience(
            account_id=facebook_account_id,
            name=segment_name,
            description=segment_description,
            facebook_token=facebook_token
        )

        audience_loader.update_audience(
            audience_from_yt=audience_from_yt,
            facebook_audience=facebook_audience,
            id_type=id_type,
            operator=operator
        )

        logging.info("Mission accomplished!")
