# -*- coding: utf-8 -*-
from collections.abc import Iterator

import yt.wrapper as yt
from yaqtypes import Token


def get_audience_from_yt(
        yt_input_table: str,
        cluster: str,
        yt_token: Token,
        id_type: str
) -> Iterator[str]:
    client = yt.YtClient(proxy=cluster, config={"tabular_data_format": "json", "token": yt_token})
    json_format = yt.JsonFormat(attributes={"encode_utf8": False})
    for row in client.read_table(yt_input_table, format=json_format):
        yield row[id_type]
