# -*- coding: utf-8 -*-

from sandbox import sdk2
from sandbox.sdk2 import yav

DAYS = 180
PERIOD = 30
FB_API_VERSION = 'v9.0'


def get_raw_insights_from_facebook(dt, account_id, facebook_token):
    from facebook_business.adobjects.adsinsights import AdsInsights
    from facebook_business import FacebookAdsApi, FacebookSession
    from facebook_business.adobjects.adaccount import AdAccount

    from datetime import timedelta

    fields = [
        AdsInsights.Field.date_start,
        AdsInsights.Field.campaign_id,
        AdsInsights.Field.campaign_name,
        AdsInsights.Field.adset_id,
        AdsInsights.Field.adset_name,
        AdsInsights.Field.ad_id,
        AdsInsights.Field.ad_name,
        AdsInsights.Field.objective,
        AdsInsights.Field.impressions,
        AdsInsights.Field.actions,
        AdsInsights.Field.spend
    ]
    params = {
        'level': AdsInsights.Level.ad,
        'filtering': [],
        'time_ranges': [{'since': str(dt - timedelta(days=i)), 'until': str(dt - timedelta(days=i))} for i in
                        range(PERIOD)]
    }

    session = FacebookSession(access_token=facebook_token)
    api = FacebookAdsApi(session, api_version=FB_API_VERSION)
    insights = AdAccount(account_id, api=api).get_insights(
        fields=fields,
        params=params,
    )

    insights = list(insights)
    for i in range(len(insights)):
        insights[i]['impressions'] = int(insights[i].get('impressions') or 0)
        insights[i]['spend'] = float(insights[i].get('spend') or 0)
        insights[i]['actions'] = insights[i].get('actions') or []

    return insights


def clicks_from_action(row):
    for elem in row:
        if elem['action_type'] == 'link_click':
            return int(elem['value'])
    return 0


def conversion_from_action(row):
    for elem in row:
        if elem['action_type'] == 'mobile_app_install':
            return int(elem['value'])
    return 0


def get_insights_from_facebook(facebook_token):
    import pandas as pd

    from datetime import date, timedelta

    columns = ['date',
               'source',
               'objective',
               'campaign_id',
               'campaign_name',
               'adset_id',
               'adset_name',
               'ad_id',
               'ad_name',
               'impressions',
               'actions',
               'spend']

    rows_list = []
    for account_id in ['act_1791088627861160']:
        for i in range(DAYS // PERIOD):
            insights = get_raw_insights_from_facebook(date.today() - timedelta(days=i * PERIOD), account_id, facebook_token)
            for ins in insights:
                rows_list.append([ins['date_start'],
                                  'facebook',
                                  ins['objective'],
                                  ins['campaign_id'],
                                  ins['campaign_name'],
                                  ins['adset_id'],
                                  ins['adset_name'],
                                  ins['ad_id'],
                                  ins['ad_name'],
                                  ins['impressions'],
                                  ins['actions'],
                                  ins['spend']])

    df = pd.DataFrame(rows_list, columns=columns)

    df['clicks'] = df['actions'].apply(lambda a: clicks_from_action(a))
    df['installs'] = df['actions'].apply(lambda a: conversion_from_action(a))
    df = df.drop('actions', axis=1)

    return df


def put_data_to_yt(df, yt_token, yt_table):
    import yt.wrapper as yt

    client = yt.YtClient(proxy="hahn",
                         config={"tabular_data_format": "json", "token": yt_token})

    schema = [
        {"name": "date", "type": "string"},
        {"name": "source", "type": "string"},
        {"name": "objective", "type": "string"},
        {"name": "campaign_id", "type": "string"},
        {"name": "campaign_name", "type": "string"},
        {"name": "adset_id", "type": "string"},
        {"name": "adset_name", "type": "string"},
        {"name": "ad_id", "type": "string"},
        {"name": "ad_name", "type": "string"},
        {"name": "spend", "type": "double"},
        {"name": "impressions", "type": "int32"},
        {"name": "clicks", "type": "int32"},
        {"name": "installs", "type": "int32"}
    ]

    client.write_table(yt.TablePath(yt_table, attributes={"schema": schema}), df.to_dict(orient='records'),
                       format=yt.JsonFormat(attributes={"encode_utf8": False}))


class FacebookMobmapsCPI(sdk2.Task):
    def on_create(self):
        self.Requirements.tasks_resource = sdk2.service_resources.SandboxTasksBinary.find(
            attrs={
                'target': 'maps/geomarketing/buying/FacebookMobmapsCPI/bin'
            }
        ).first()

    def on_execute(self):
        secret_yt_token = yav.Secret("sec-01ent9wp5rkfmtyjm0skkm408h")
        secret_facebook_token = yav.Secret("sec-01eppv1wsztdp7jp8gjd04vayj")

        yt_token = secret_yt_token.data()["TOKEN"]
        facebook_token = secret_facebook_token.data()["chizhonkov_facebook_token"]

        facebook_df = get_insights_from_facebook(facebook_token)

        put_data_to_yt(facebook_df,
                       yt_token,
                       '//home/geo-analytics/marketing/datasets/buying/mobmaps/cpi/facebook')
