# -*- coding: utf-8 -*-

from sandbox import sdk2
from sandbox.sdk2 import yav

CHUNK_SIZE = 100000 * 1024
DAYS = 180


def get_google_client():
    from googleads import adwords, oauth2

    secret_google_ads_developer_token = yav.Secret("sec-01er29n335pdyv2wytnt5ckvnx")
    secret_google_ads_refresh_token = yav.Secret("sec-01er29memy5v2vferks008f67s")
    secret_google_ads_client_secret = yav.Secret("sec-01er29kkftcy7gfy5zy90z366m")
    secret_google_ads_oauth2_client = yav.Secret("sec-01er29j2gkqmsgsd242e620mm3")

    developer_token = secret_google_ads_developer_token.data()["developer_token"]
    refresh_token = secret_google_ads_refresh_token.data()["refresh_token"]
    client_secret = secret_google_ads_client_secret.data()["client_secret"]
    oauth2_client = secret_google_ads_oauth2_client.data()["oauth2_client"]

    oauth2_client = oauth2.GoogleRefreshTokenClient(oauth2_client, client_secret, refresh_token)
    client = adwords.AdWordsClient(
        developer_token=developer_token,
        oauth2_client=oauth2_client,
        client_customer_id="881-856-4420",
        timeout=30,
    )
    return client


def get_app_insights_from_google(dt):
    from googleads import adwords
    from datetime import timedelta
    import io

    client = get_google_client()

    report_downloader = client.GetReportDownloader(version='v201809')

    report_query = (adwords.ReportQueryBuilder()
                    .Select('Date', 'CampaignId', 'CampaignName',
                            'Impressions', 'Clicks', 'Conversions', 'Cost')
                    .From('CAMPAIGN_PERFORMANCE_REPORT')
                    .During(date_range=None, start_date=dt - timedelta(days=DAYS), end_date=dt)
                    .Build())

    report_data = io.StringIO()
    stream_data = report_downloader.DownloadReportAsStreamWithAwql(report_query, 'CSV', skip_report_header=True,
                                                                   skip_column_header=True, skip_report_summary=True,
                                                                   include_zero_impressions=False)

    try:
        while True:
            chunk = stream_data.read(CHUNK_SIZE)
            if not chunk: break
            report_data.write(chunk.decode("utf8"))
            return report_data.getvalue()
    finally:
        report_data.close()
        stream_data.close()


def get_insights_from_google():
    import pandas as pd
    from datetime import date

    dt = date.today()

    app_insights = get_app_insights_from_google(dt)

    columns = ['date',
               'campaign_id',
               'campaign_name',
               'impressions',
               'clicks',
               'conversions',
               'spend']

    rows_list = []
    for insights in [app_insights]:
        if insights:
            for insight in insights.split('\n'):
                ins = insight.split(',')
                if len(ins) == len(columns):
                    rows_list.append(ins)

    df = pd.DataFrame(rows_list, columns=columns)

    df['impressions'] = df['impressions'].astype('int')
    df['clicks'] = df['clicks'].astype('int')
    df['conversions'] = df['conversions'].astype('double')
    df['spend'] = df['spend'].apply(lambda s: int(s) / 1000000.)
    df['source'] = 'google'

    return df


def put_data_to_yt(df, yt_table):
    import yt.wrapper as yt

    secret_yt_token = yav.Secret("sec-01ent9wp5rkfmtyjm0skkm408h")
    yt_token = secret_yt_token.data()["TOKEN"]

    client = yt.YtClient(proxy="hahn",
                         config={"tabular_data_format": "json", "token": yt_token})

    schema = [
            {"name":"date","type":"string"},
            {"name":"source","type":"string"},
            {"name":"campaign_id","type":"string"},
            {"name":"campaign_name","type":"string"},
            {"name":"spend","type":"double"},
            {"name":"impressions","type":"int32"},
            {"name":"clicks","type":"int32"},
            {"name":"conversions","type":"double"}
             ]

    client.write_table(yt.TablePath(yt_table, attributes={"schema": schema}), df.to_dict(orient='records'),
                       format=yt.JsonFormat(attributes={"encode_utf8": False}))


class GoogleAdsMobmapsCPI(sdk2.Task):
    def on_create(self):
        self.Requirements.tasks_resource = sdk2.service_resources.SandboxTasksBinary.find(
            attrs={
                'target': 'maps/geomarketing/buying/GoogleAdsMobmapsCPI/bin'
            }
        ).first()

    def on_execute(self):
        google_df = get_insights_from_google()
        put_data_to_yt(google_df, '//home/geo-analytics/marketing/datasets/buying/mobmaps/cpi/google-ads')
