# -*- coding: utf-8 -*-

from sandbox import sdk2
from sandbox.sdk2 import yav
import sandbox.common.types.misc as ctm

DAYS = 180

ReportsURL = 'https://api.direct.yandex.com/json/v5/reports'
clientLogin = 'yndx-b2bgeo'


def get_name():
    from datetime import datetime

    now = datetime.now()
    return "ya_direct_" + str(now.month) + '_' + str(now.day) + '_' + str(now.hour) + '_' + str(now.second)


def get_search_insights_from_yandex():
    from datetime import date, timedelta
    import json
    from time import sleep
    import requests

    secret_direct_token = yav.Secret("sec-01ewjrzyq5fc7wdmjw5bp7f41s")
    direct_token = secret_direct_token.data()["token"]

    headers = {
        "Authorization": "Bearer " + direct_token,
        "Client-Login": clientLogin,
        "Accept-Language": "ru",
        "processingMode": "auto",
        "returnMoneyInMicros": "false",
        "skipReportHeader": "true",
        "skipColumnHeader": "true",
        "skipReportSummary": "true"
    }

    body = {
        "params": {
            "SelectionCriteria": {
                "DateFrom": str(date.today() - timedelta(days=DAYS)),
                "DateTo": str(date.today()),
                "Filter": [{
                    "Field": "AdNetworkType",
                    "Operator": "EQUALS",
                    "Values": ["SEARCH"]
                }]
            },
            "Goals": ["51667681", "129307987"],
            "FieldNames": [
                "Date",
                "CampaignId",
                "CampaignName",
                "AdGroupId",
                "AdGroupName",
                "CriterionId",
                "Criterion",
                "Impressions",
                "Clicks",
                "Conversions",
                "Cost"
            ],
            "ReportName": get_name(),
            "ReportType": "CRITERIA_PERFORMANCE_REPORT",
            "DateRangeType": "CUSTOM_DATE",
            "Format": "TSV",
            "IncludeVAT": "YES",
            "IncludeDiscount": "NO"
        }
    }
    body = json.dumps(body, indent=4)

    while True:
        req = requests.post(ReportsURL, body, headers=headers)
        req.encoding = 'utf-8'
        if req.text:
            break
        sleep(3)

    return req.text


def get_network_insights_from_yandex():
    from datetime import date, timedelta
    import json
    from time import sleep
    import requests

    secret_direct_token = yav.Secret("sec-01ewjrzyq5fc7wdmjw5bp7f41s")
    direct_token = secret_direct_token.data()["token"]

    headers = {
        "Authorization": "Bearer " + direct_token,
        "Client-Login": clientLogin,
        "Accept-Language": "ru",
        "processingMode": "auto",
        "returnMoneyInMicros": "false",
        "skipReportHeader": "true",
        "skipColumnHeader": "true",
        "skipReportSummary": "true"
    }
    body = {
        "params": {
            "SelectionCriteria": {
                "DateFrom": str(date.today() - timedelta(days=DAYS)),
                "DateTo": str(date.today()),
                "Filter": [{
                    "Field": "AdNetworkType",
                    "Operator": "EQUALS",
                    "Values": ["AD_NETWORK"]
                }, {
                    "Field": "AdFormat",
                    "Operator": "NOT_EQUALS",
                    "Values": ["VIDEO"]
                }]
            },
            "Goals": ["51667681", "129307987"],
            "FieldNames": [
                "Date",
                "CampaignId",
                "CampaignName",
                "AdGroupId",
                "AdGroupName",
                "AdId",
                "AdId",
                "Impressions",
                "Clicks",
                "Conversions",
                "Cost"
            ],
            "ReportName": get_name(),
            "ReportType": "AD_PERFORMANCE_REPORT",
            "DateRangeType": "CUSTOM_DATE",
            "Format": "TSV",
            "IncludeVAT": "YES",
            "IncludeDiscount": "NO"
        }
    }
    body = json.dumps(body, indent=4)

    while True:
        req = requests.post(ReportsURL, body, headers=headers)
        req.encoding = 'utf-8'
        if req.text:
            break
        sleep(3)

    return req.text


def get_insights_from_yandex():
    import pandas as pd

    search_insights = get_search_insights_from_yandex()
    network_insights = get_network_insights_from_yandex()

    columns = ['date',
               'campaign_id',
               'campaign_name',
               'adset_id',
               'adset_name',
               'ad_id',
               'ad_name',
               'impressions',
               'clicks',
               'leads_offline',
               'leads_online',
               'spend']

    rows_list = []
    for insights in [search_insights, network_insights]:
        for insight in insights.split('\n'):
            ins = insight.split('\t')
            if len(ins) == len(columns):
                rows_list.append(ins)

    df = pd.DataFrame(rows_list, columns=columns)

    df['impressions'] = df['impressions'].astype('int')
    df['clicks'] = df['clicks'].astype('int')
    df['leads_offline'] = df['leads_offline'].apply(lambda l: 0 if l == '--' else int(l))
    df['leads_online'] = df['leads_online'].apply(lambda l: 0 if l == '--' else int(l))
    df['leads'] = df['leads_offline'] + df['leads_online']
    df.drop(['leads_offline', 'leads_online'], axis=1, inplace=True)
    df['spend'] = df['spend'].astype('float')
    df['source'] = 'yandex'

    return df


def put_data_to_yt(df, yt_table):
    import yt.wrapper as yt

    secret_yt_token = yav.Secret("sec-01ent9wp5rkfmtyjm0skkm408h")
    yt_token = secret_yt_token.data()["TOKEN"]

    client = yt.YtClient(proxy="hahn",
                         config={"tabular_data_format": "json", "token": yt_token})

    schema = [
        {"name": "date", "type": "string"},
        {"name": "source", "type": "string"},
        {"name": "campaign_id", "type": "string"},
        {"name": "campaign_name", "type": "string"},
        {"name": "adset_id", "type": "string"},
        {"name": "adset_name", "type": "string"},
        {"name": "ad_id", "type": "string"},
        {"name": "ad_name", "type": "string"},
        {"name": "spend", "type": "double"},
        {"name": "impressions", "type": "int32"},
        {"name": "clicks", "type": "int32"},
        {"name": "leads", "type": "int32"},
    ]

    client.write_table(yt.TablePath(yt_table, attributes={"schema": schema}), df.to_dict(orient='records'),
                       format=yt.JsonFormat(attributes={"encode_utf8": False}))


class YandexDirectSMB(sdk2.Task):
    class Requirements(sdk2.Requirements):
        dns = ctm.DnsType.DNS64

    def on_create(self):
        self.Requirements.tasks_resource = sdk2.service_resources.SandboxTasksBinary.find(
            attrs={
                'target': 'maps/geomarketing/buying/YandexDirectSMB/bin'
            }
        ).first()

    def on_execute(self):
        yandex_df = get_insights_from_yandex()
        put_data_to_yt(yandex_df, '//home/geo-analytics/marketing/datasets/buying/smb/cpl/yandex-direct')
