import datetime


class Issue(object):
    status = 'WARN'
    priority = 3

    def __str__(self):
        return 'Unknown issue'


class NoDataIssue(Issue):
    status = 'CRIT'
    priority = 0

    def __init__(self, duration):
        self.duration = duration

    def __str__(self):
        return 'There is no finished tasks for {duration}'.format(
            duration=datetime.timedelta(seconds=self.duration))


class LastTaskFailure(Issue):
    status = 'CRIT'
    priority = 1

    def __init__(self, task_id, status):
        self.task_id = task_id
        self.status = status

    def __str__(self):
        return 'Task {task_id} finished with status {status}'.format(
            task_id=self.task_id, status=self.status)


class LongExecutionTime(Issue):
    status = 'WARN'
    priority = 2

    def __init__(self, task_id, duration, mean_duration):
        self.task_id = task_id
        self.duration = duration

    def __str__(self):
        return (
            'Task {task_id} runs for {duration}, '
            'but it\'s longer than usual {mean_duration}'.format(
                task_id=self.task_id,
                duration=datetime.timedelta(seconds=self.duration),
                mean_duration=datetime.timedelta(seconds=self.mean_duration)))
