from datetime import datetime


def duration(past, present):
    """
        Calculates time in seconds between past and present

        a, b: datetime
    """
    return (
        present.replace(tzinfo=None)
        - past.replace(tzinfo=None)).total_seconds()


def timestamp(dt):
    """
        One of the greatest mysteries on Earth:
            For some reason there is no native function to
            convert your datetime into timestamp in Python 2.

        So we need to improvise...

        dt: datetime
    """
    return duration(datetime.fromtimestamp(0), dt)


def mean(a):
    return sum(a) / len(a) if a else 0.0
