import os

from sandbox import sdk2
from sandbox.projects.maps.geoq.GeoqBinaryTask import (
    GeoqBinaryTask,
    GeoqExecutableResourceWithAutoDiscovery,
)


class GeoqStreetviewMarkupPermalinksGeneratorExecutable(GeoqExecutableResourceWithAutoDiscovery):
    pass


class GeoqStreetviewMarkupPermalinksGeneratorYqlUdf(GeoqExecutableResourceWithAutoDiscovery):
    pass


class GeoqStreetviewMarkupPermalinksGenerator(GeoqBinaryTask):
    class Parameters(GeoqBinaryTask.Parameters):
        with sdk2.parameters.Group('Executable') as executable_parameters:
            generate_executable = sdk2.parameters.Resource(
                'Generate permalinks executable',
                resource_type=GeoqStreetviewMarkupPermalinksGeneratorExecutable
            )
            generate_yql_udf = sdk2.parameters.Resource(
                'Generate permalinks yql udf',
                resource_type=GeoqStreetviewMarkupPermalinksGeneratorYqlUdf
            )

        with sdk2.parameters.Group('Tokens') as token_parameters:
            yt_token = sdk2.parameters.YavSecret('YT OAuth token', required=True)
            yql_token = sdk2.parameters.YavSecret('YQL OAuth token', required=True)

        with sdk2.parameters.Group('Pipeline parameters') as pipeline_parameters:
            add_polygons_tables = sdk2.parameters.List(
                'Tables with polygons which should be added',
                sdk2.parameters.String,
                default=[]
            )
            filter_polygons_tables = sdk2.parameters.List(
                'Final filtering will be made by these polygons',
                sdk2.parameters.String,
                default=[]
            )
            geoproduct_permalinks = sdk2.parameters.String(
                'Table with geoproduct permalinks',
                default='//home/geoadv/export/production/priority_company_permanent_id'
            )
            output_table = sdk2.parameters.String(
                'Table with result',
                required=True,
            )

    def on_execute(self):
        at_least_one_source = self.Parameters.add_polygons_tables \
            or self.Parameters.geoproduct_permalinks
        if not at_least_one_source:
            raise ValueError('At least one permalinks source should be set!')

        os.environ.update({
            'YT_PROXY': 'hahn.yt.yandex.net',
            'YT_TOKEN': self.Parameters.yt_token.value(),
            'YQL_TOKEN': self.Parameters.yql_token.value(),
            'NILE_YQL_PYTHON_UDF_PATH': self.fetch_resource(self.Parameters.generate_yql_udf),
        })

        arguments = [
            '--output-table', str(self.Parameters.output_table),
        ]
        if self.Parameters.add_polygons_tables:
            arguments.append('--add-polygons-tables')
            for table in self.Parameters.add_polygons_tables:
                arguments.append(table)
        if self.Parameters.filter_polygons_tables:
            arguments.append('--filter-polygons-tables')
            for table in self.Parameters.filter_polygons_tables:
                arguments.append(table)
        if self.Parameters.geoproduct_permalinks:
            arguments.extend([
                '--geoproduct-permalinks', str(self.Parameters.geoproduct_permalinks)
            ])

        self.run_executable(self.Parameters.generate_executable, arguments, 'Generate')
