import os

from sandbox import sdk2
import logging

from sandbox.projects.maps.geoq.GeoqBinaryTask import (
    GeoqBinaryTask,
    GeoqExecutableResourceWithAutoDiscovery,
)


class GeoqUnshownPopularOrgsExecutable(GeoqExecutableResourceWithAutoDiscovery):
    pass


class GeoqUnshownPopularOrgsYqlUdf(GeoqExecutableResourceWithAutoDiscovery):
    pass


class GeoqUnshownPopularOrgs(GeoqBinaryTask):
    class Parameters(GeoqBinaryTask.Parameters):
        with sdk2.parameters.Group('Executable') as executable_parameters:
            executable = sdk2.parameters.Resource(
                'Unshown popular orgs executable', resource_type=GeoqUnshownPopularOrgsExecutable)
            yql_udf = sdk2.parameters.Resource(
                'Unshown popular orgs YQL UDF .so binary', resource_type=GeoqUnshownPopularOrgsYqlUdf)

        # TODO I have a feeling that i need to implement something called 'dry run', but i'm not exactly sure what it is
        with sdk2.parameters.Group('Output') as output_parameters:
            results_dir = sdk2.parameters.String(
                'Path to directory where to publish the results', required=True)
            result_table_name = sdk2.parameters.String(
                'Version name (datetime by default')

        with sdk2.parameters.Group('Execution') as execution_parameters:
            polygons = sdk2.parameters.String(
                'Path to table with expanded cities polygons')
            checkpoints = sdk2.parameters.List(
                'Checkpoint from which to start Nile execution')
            whitelist_countries = sdk2.parameters.List(
                'Whitelist of countries, ISO codes, eg. \'RU BY TR\'')
            deepclicks_top_percent = sdk2.parameters.Float(
                'Deepclicks percent to form top ([0..100], default is 1.0)')
            orgvisits_top_percent = sdk2.parameters.Float(
                'Orgvisits percent to form top ([0..100], default is 1.0)')
            dispclass_top_percent = sdk2.parameters.Float(
                'Dispclass percent to form top ([0..100], default is 1.0)')

        with sdk2.parameters.Group('YT parameters') as token_parameters:
            yt_token = sdk2.parameters.YavSecret('YT OAuth token', required=True)
            yql_token = sdk2.parameters.YavSecret('YQL OAuth token', required=True)
            yt_pool = sdk2.parameters.String(
                'YT processing pool',
                default='maps-core-popular-unshown-orgs',
            )

    def run_pipeline_executable(self):
        arguments = [
            '--results-dir',
            self.Parameters.results_dir,
        ]
        if self.Parameters.yt_pool:
            arguments += ['--yt-pool', self.Parameters.yt_pool]
        if self.Parameters.result_table_name:
            arguments += ['--result-table-name', self.Parameters.result_table_name]
        if self.Parameters.polygons:
            arguments += ['--polygons', self.Parameters.polygons]
        if self.Parameters.checkpoints:
            arguments += ['--checkpoints']
            arguments.extend(self.Parameters.checkpoints)
        if self.Parameters.whitelist_countries:
            arguments += ['--whitelist-countries']
            arguments.extend(self.Parameters.whitelist_countries)
        if self.Parameters.deepclicks_top_percent:
            arguments += ['--deepclicks-top-percent', self.Parameters.deepclicks_top_percent]
        if self.Parameters.orgvisits_top_percent:
            arguments += ['--orgvisits-top-percent', self.Parameters.orgvisits_top_percent]
        if self.Parameters.dispclass_top_percent:
            arguments += ['--dispclass-top-percent', self.Parameters.dispclass_top_percent]
        self.run_executable(self.Parameters.executable, arguments, 'Execution')

    def on_execute(self):
        logging.info('Initiate UnshownPopularOrgs sequence...')

        os.environ.update({
            'YT_PROXY': 'hahn.yt.yandex.net',
            'YT_TOKEN': self.Parameters.yt_token.value(),
            'YQL_TOKEN': self.Parameters.yql_token.value(),
            'NILE_YQL_PYTHON_UDF_PATH': self.fetch_resource(self.Parameters.yql_udf),
        })

        self.run_pipeline_executable()
