import os

from sandbox import sdk2
from sandbox.projects.maps.geoq.GeoqBinaryTask import (
    GeoqBinaryTask,
    GeoqExecutableResourceWithAutoDiscovery,
)


class GeoqFlatsHypothesesPrepareExecutable(GeoqExecutableResourceWithAutoDiscovery):
    pass


class GeoqFlatsHypothesesUploadExecutable(GeoqExecutableResourceWithAutoDiscovery):
    pass


class GeoqFlatsHypothesesYqlUdf(GeoqExecutableResourceWithAutoDiscovery):
    pass


class GeoqFlatsHypotheses(GeoqBinaryTask):
    class Parameters(GeoqBinaryTask.Parameters):
        with sdk2.parameters.Group('Executable') as executable_parameters:
            prepare_executable = sdk2.parameters.Resource(
                'Flats prepare executable', resource_type=GeoqFlatsHypothesesPrepareExecutable)
            upload_executable = sdk2.parameters.Resource(
                'Flats upload executable', resource_type=GeoqFlatsHypothesesUploadExecutable)
            yql_udf = sdk2.parameters.Resource(
                'Flats yql udf', resource_type=GeoqFlatsHypothesesYqlUdf)

        with sdk2.parameters.Group('Tokens') as token_parameters:
            yt_token = sdk2.parameters.YavSecret('YT OAuth token', required=True)
            yql_token = sdk2.parameters.YavSecret('YQL OAuth token', required=True)
            tvm_secret = sdk2.parameters.YavSecret('TVM token', required=True)
            statface_token = sdk2.parameters.YavSecret('Statface OAuth token', required=True)

        with sdk2.parameters.Group('Pipeline parameters') as pipeline_parameters:
            regions = sdk2.parameters.List(
                'Ymapsdf regions to handle', sdk2.parameters.String, default=['cis1']
            )
            hypotheses_types = sdk2.parameters.List(
                'Flats hypotheses to generate', sdk2.parameters.String, default=['exact-entrance']
            )

        with sdk2.parameters.Group('Statistics parameters') as statistics_parameters:
            stat_report_path = sdk2.parameters.String(
                'Path to publish the report to (if given)')

            with sdk2.parameters.RadioGroup('Statface proxy to use') as stat_proxy:
                stat_proxy.values.prod = stat_proxy.Value(
                    value='prod')
                stat_proxy.values.beta = stat_proxy.Value(
                    value='beta', default=True)

    def run_prepare_executable(self, output_table_path, name):
        arguments = [
            '--output-table',
            output_table_path,
            name,
        ]
        self.run_executable(self.Parameters.prepare_executable, arguments, 'Prepare')

    def run_upload_executable(self, tables):
        os.environ.update({
            'TVM_SECRET': self.Parameters.tvm_secret.value(),
            'STAT_TOKEN': self.Parameters.statface_token.value(),
        })

        arguments = ['--hypotheses-tables']
        arguments += tables

        if self.Parameters.stat_report_path:
            arguments += [
                '--statface-proxy', self.Parameters.stat_proxy,
                '--statface-report-path', self.Parameters.stat_report_path
            ]

        self.run_executable(self.Parameters.upload_executable, arguments, 'Upload')

    def on_execute(self):
        os.environ.update({
            'YT_PROXY': 'hahn.yt.yandex.net',
            'YT_TOKEN': self.Parameters.yt_token.value(),
            'YQL_TOKEN': self.Parameters.yql_token.value(),
            'NILE_YQL_PYTHON_UDF_PATH': self.fetch_resource(self.Parameters.yql_udf),
        })

        output_tables = []
        for name in self.Parameters.hypotheses_types:
            output_table_path = '//home/maps/poi/flats/{}/hypotheses/{}'.format(self.Parameters.environment, name)
            self.run_prepare_executable(output_table_path, name)
            output_tables.append(output_table_path)

        self.run_upload_executable(output_tables)
