import os

from sandbox import sdk2
from sandbox.projects.maps.geoq.GeoqBinaryTask import GeoqBinaryTask, GeoqExecutableResourceWithAutoDiscovery


class GeoqLooseSignalsHypothesesPrepareExecutable(GeoqExecutableResourceWithAutoDiscovery):
    pass


class GeoqLooseSignalsHypothesesUploadExecutable(GeoqExecutableResourceWithAutoDiscovery):
    pass


class GeoqLooseSignalsHypotheses(GeoqBinaryTask):
    class Parameters(GeoqBinaryTask.Parameters):
        with sdk2.parameters.Group('Executable') as executable_parameters:
            prepare_executable = sdk2.parameters.Resource(
                'Loose signals prepare executable', resource_type=GeoqLooseSignalsHypothesesPrepareExecutable)
            upload_executable = sdk2.parameters.Resource(
                'Loose signals upload executable', resource_type=GeoqLooseSignalsHypothesesUploadExecutable)

        with sdk2.parameters.Group('Tokens') as token_parameters:
            yt_token = sdk2.parameters.YavSecret('YT OAuth token', required=True)
            yql_token = sdk2.parameters.YavSecret('YQL OAuth token', required=True)
            static_map_api_key = sdk2.parameters.YavSecret(
                'Static Map API key', description='key for descriptions')
            static_map_secret = sdk2.parameters.YavSecret(
                'Static Map API secret', description='key for descriptions')
            tvm_token = sdk2.parameters.YavSecret('TVM token')

        with sdk2.parameters.Group('Pipeline parameters') as pipeline_parameters:
            start_date = sdk2.parameters.String(
                'Start date in format {}')
            date_count = sdk2.parameters.Integer(
                'Number of days to use', default=7)

        with sdk2.parameters.Group('Upload parameters') as upload_parameters:
            hypotheses_count = sdk2.parameters.Integer(
                'Number of hypotheses to upload', default=10)
            dry_run = sdk2.parameters.Bool(
                'Dry run', description='No hypotheses will be uploaded', default=False)
            use_tvm = sdk2.parameters.Bool(
                'Use tvm', default=False)

    def run_prepare_executable(self):
        arguments = [
            '--date-count', self.Parameters.date_count,
        ]
        if self.Parameters.start_date:
            arguments += ['--start-date', self.Parameters.start_date]

        self.run_executable(self.Parameters.prepare_executable, arguments, 'Prepare')

    def run_upload_executable(self):
        if self.Parameters.static_map_api_key and self.Parameters.static_map_secret:
            os.environ.update({
                'STATIC_MAP_TOKEN': self.Parameters.static_map_api_key.value(),
                'STATIC_MAP_SECRET': self.Parameters.static_map_secret.value(),
            })

        arguments = [
            '--count', self.Parameters.hypotheses_count,
        ]

        if self.Parameters.use_tvm:
            os.environ.update({
                'TVM_TOKEN': self.Parameters.tvm_token.value()
            })
            arguments.append('--use-tvm')

        if self.Parameters.dry_run:
            arguments.append('--dry-run')

        self.run_executable(self.Parameters.upload_executable, arguments, 'Upload')

    def on_execute(self):
        os.environ.update({
            'YT_TOKEN': self.Parameters.yt_token.value(),
            'YQL_TOKEN': self.Parameters.yql_token.value()
        })

        self.run_prepare_executable()
        self.run_upload_executable()
