# -*- coding: utf-8 -*-

from sandbox import sdk2
import sandbox.projects.resource_types.releasers as resource_releasers


class MAPS_GOODS_FUNDUK_FRESHNESS_SCRIPT(sdk2.Resource):
    '''
        YQL-script to calculate funduk freshness
    '''
    auto_backup = True
    releasable = True
    releasers = resource_releasers.funduk_releasers


class MAPS_GOODS_FUNDUK_RECALL_SCRIPT(sdk2.Resource):
    '''
        YQL-script to calculate funduk recall
    '''
    auto_backup = True
    releasable = True
    releasers = resource_releasers.funduk_releasers


class MAPS_GOODS_FUNDUK_STATISTICS_CALCULATOR(sdk2.Resource):
    '''
        Executor of statistical YQL scripts for Funduk
    '''
    auto_backup = True
    releasable = True
    releasers = resource_releasers.funduk_releasers


class MAPS_GOODS_FUNDUK_EXPORT_BASE(sdk2.Resource):
    '''
        Export base flow for Funduk
    '''
    auto_backup = True
    releasable = True
    releasers = resource_releasers.funduk_releasers


class MAPS_GOODS_FUNDUK_TAGGING_APPLY(sdk2.Resource):
    '''
        Tagging apply flow for Funduk
    '''
    auto_backup = True
    releasable = True
    releasers = resource_releasers.funduk_releasers


class MAPS_GOODS_FUNDUK_UPDATE_DATA_FROM_PROVIDERS(sdk2.Resource):
    '''
        Update data from providers flow for Funduk
    '''
    auto_backup = True
    releasable = True
    releasers = resource_releasers.funduk_releasers


class MAPS_GOODS_ORGANIZATION_IMPORTER(sdk2.Resource):
    '''
        Import organizations from Sprav to goods and services database
    '''
    auto_backup = True
    releasable = True
    releasers = resource_releasers.funduk_releasers


class MAPS_GOODS_POINTER_DOWNLOADER(sdk2.Resource):
    '''
        Download and validate pointer's feed
    '''
    auto_backup = True
    releasable = True
    releasers = resource_releasers.funduk_releasers


class MAPS_GOODS_FEED_SYNCHRONIZER(sdk2.Resource):
    '''
        Synchronize feeds data in goods database
    '''
    auto_backup = True
    releasable = True
    releasers = resource_releasers.funduk_releasers


class MAPS_GOODS_EXPORT_TYCOON(sdk2.Resource):
    '''
        Export Tycoon goods from PG to YT
    '''
    auto_backup = True
    releasable = True
    releasers = resource_releasers.funduk_releasers


class MAPS_GOODS_PHOTO_UPLOADER_YT(sdk2.Resource):
    '''
        Upload photos to Avatars
    '''
    auto_backup = True
    releasable = True
    releasers = resource_releasers.funduk_releasers


class MAPS_GOODS_PHOTO_DELETER_YT(sdk2.Resource):
    '''
        Delete photos from Avatars
    '''
    auto_backup = True
    releasable = True
    releasers = resource_releasers.funduk_releasers


class MAPS_GOODS_MODERATOR_YT(sdk2.Resource):
    '''
        Form moderation cache
    '''
    auto_backup = True
    releasable = True
    releasers = resource_releasers.funduk_releasers

class MAPS_GOODS_AVATARS_INFO(sdk2.Resource):
    '''
        Form gather avatars info
    '''
    auto_backup = True
    releasable = True
    releasers = resource_releasers.funduk_releasers
