from sandbox import sdk2


class SedemExecutable(sdk2.resource.AbstractResource):
    """
        SEDEM binary
    """
    releasable = True
    executable = True
    any_arch = False
    ttl = 'inf'


class SedemArchive(sdk2.resource.AbstractResource):
    """
        SEDEM tar.gz
    """
    releasable = True
    executable = False
    any_arch = False
    ttl = 'inf'


class SedemCommonDocs(sdk2.resource.AbstractResource):
    """
        Common documentation for SEDEM release (generated by SEDEM)
    """
    releasable = True
    executable = False
    any_arch = True
    ttl = 'inf'


class SedemServicePage(sdk2.resource.AbstractResource):
    """
        HTML page for one Service
    """
    releasable = True
    executable = False
    any_arch = True
    ttl = 'inf'
    sedem_service = 'core-sedem-service'


class SedemServiceToc(sdk2.resource.AbstractResource):
    """
        HTML page with list of all services
    """
    releasable = True
    executable = False
    any_arch = True
    ttl = 'inf'


class SedemBaseImageMarker(sdk2.resource.AbstractResource):
    """
        Marker of Docker Base Image (used as build artifact in RM)
    """
    releasable = True
    executable = False
    any_arch = True
    ttl = 'inf'
    resource_name = 'core-sedem-service'
    svn_revision = 0


class SedemBalancerDeployerExecutable(sdk2.resource.AbstractResource):
    """
        SEDEM binary balancer deployer
    """
    releasable = True
    executable = True
    any_arch = False
    ttl = 'inf'
