#!/usr/bin/env bash	set -o errexit
set -o xtrace

dpkg --add-architecture i386
apt-get -yqq update || true
apt-get install -qq --assume-yes --no-install-recommends daemon cpu-checker curl git ca-certificates unzip yandex-jdk8 qemu-kvm libvirt-bin ubuntu-vm-builder bridge-utils libxdamage1 libxfixes3 libc6:i386 libncurses5:i386 libstdc++6:i386 zlib1g:i386 xvfb

curl --verbose --insecure -o sdk-tools.zip https://dl.google.com/android/repository/sdk-tools-linux-3859397.zip
mkdir -p /usr/local/android-sdk-linux
unzip sdk-tools.zip -d /usr/local/android-sdk-linux
rm sdk-tools.zip

tee /etc/profile.d/66-android.sh << "EOF"
export ANDROID_HOME=/usr/local/android-sdk-linux
export PATH=$ANDROID_HOME/platform-tools:$ANDROID_HOME/tools:$ANDROID_HOME/tools/bin:$ANDROID_HOME/emulator:$PATH
EOF

tee /etc/profile.d/55-java.sh << "EOF"
export JAVA_HOME=/usr/local/java8
export JAVA_TOOL_OPTIONS="-Djava.net.preferIPv4Stack=false -Djava.net.preferIPv6Addresses=true"
EOF

. /etc/profile

yes | sdkmanager --licenses

sdkmanager "tools" "platform-tools" "build-tools;26.0.2" "build-tools;25.0.3" "platforms;android-26" "system-images;android-26;google_apis;x86_64"

# "platforms;android-21" "system-images;android-21;google_apis;x86_64" "platforms;android-22" "system-images;android-22;google_apis;x86_64" "platforms;android-23" "system-images;android-23;google_apis;x86_64" "platforms;android-24" "system-images;android-24;google_apis;x86_64" "platforms;android-25" "system-images;android-25;google_apis;x86_64"

#echo "n" | avdmanager create avd -n emulator21-x86_64-google -k "system-images;android-21;google_apis;x86_64"
#echo "n" | avdmanager create avd -n emulator22-x86_64-google -k "system-images;android-22;google_apis;x86_64"
#echo "n" | avdmanager create avd -n emulator23-x86_64-google -k "system-images;android-23;google_apis;x86_64"
#echo "n" | avdmanager create avd -n emulator24-x86_64-google -k "system-images;android-24;google_apis;x86_64"
#echo "n" | avdmanager create avd -n emulator25-x86_64-google -k "system-images;android-25;google_apis;x86_64"
echo "n" | avdmanager create avd -n emulator26-x86_64-google -k "system-images;android-26;google_apis;x86_64"
# all scripts goes to /usr/local/bin

##########################################
# emulator
##########################################

tee /usr/local/bin/emulator-start.sh << "EOF"
#!/bin/bash
. /etc/profile
export SHELL=/bin/bash
export LD_LIBRARY_PATH=$ANDROID_HOME/emulator/lib64/:$ANDROID_HOME/emulator/lib64/gles_mesa:$ANDROID_HOME/emulator/lib64/qt/lib/:$LD_LIBRARY_PATH
ldconfig

LOGS_DIR=${1:-/var/log}
echo "Logs dir: $LOGS_DIR"

# display to be able to run with -gpu mesa to make webview work
# Xvfb should be running
DISPLAY=:1.0 daemon --verbose --name android-emulator --unsafe --chdir=$ANDROID_HOME/tools --errlog=$LOGS_DIR/android-emulator.error.log --dbglog=$LOGS_DIR/android-emulator.debug.log --output=$LOGS_DIR/android-emulator.output.log --inherit --env="QEMU_AUDIO_DRV=none" -- emulator -avd api-26-x86_64-google -verbose -accel on -no-window -no-audio -gpu mesa -qemu -enable-kvm
EOF
chmod 755 /usr/local/bin/emulator-start.sh

tee /usr/local/bin/emulator-stop.sh << "EOF"
#!/bin/bash

daemon --stop --verbose --name android-emulator
EOF
chmod 755 /usr/local/bin/emulator-stop.sh

tee /usr/local/bin/emulator-status.sh << "EOF"
#!/bin/bash

daemon --running --verbose --name android-emulator
EOF
chmod 755 /usr/local/bin/emulator-status.sh

##########################################
# logcat
##########################################

#tee /usr/local/bin/logcat-start.sh << "EOF"
# #!/bin/bash
#. /etc/profile
#
#LOGS_DIR=${1:-/var/log}
#echo "Logs dir: $LOGS_DIR"
#
#daemon --verbose --name logcat --unsafe --errlog=$LOGS_DIR/logcat.error.log --dbglog=$LOGS_DIR/logcat.debug.log --output=$LOGS_DIR/logcat.output.log --respawn  -- adb logcat -v time
#EOF
#chmod 755 /usr/local/bin/logcat-start.sh

#tee /usr/local/bin/logcat-stop.sh << "EOF"
##!/bin/bash
#
#daemon --stop --verbose --name logcat
#EOF
#chmod 755 /usr/local/bin/logcat-stop.sh

#tee /usr/local/bin/logcat-status.sh << "EOF"
# #!/bin/bash
#
#daemon --running --verbose --name logcat
#EOF
#chmod 755 /usr/local/bin/logcat-stop.sh

##########################################
# Xvfb
##########################################

tee /usr/local/bin/Xvfb-start.sh << "EOF"
#!/bin/bash
. /etc/profile

LOGS_DIR=${1:-/var/log}
echo "Logs dir: $LOGS_DIR"

# create display to be able to run with -gpu mesa to make webview work
# set TMPDIR - workaround for bug:
# https://bugs.launchpad.net/ubuntu/+source/xorg-server/+bug/972324

TMPDIR=/var/tmp daemon --verbose --name Xvfb --unsafe --errlog=$LOGS_DIR/Xvfb.error.log --dbglog=$LOGS_DIR/Xvfb.debug.log --output=$LOGS_DIR/Xvfb.output.log --respawn -- Xvfb :1 -screen 0 800x600x16
EOF
chmod 755 /usr/local/bin/Xvfb-start.sh

tee /usr/local/bin/Xvfb-stop.sh << "EOF"
#!/bin/bash

daemon --stop --verbose --name Xvfb
EOF
chmod 755 /usr/local/bin/Xvfb-stop.sh

tee /usr/local/bin/Xvfb-status.sh << "EOF"
#!/bin/bash

daemon --running --verbose --name Xvfb
EOF
chmod 755 /usr/local/bin/Xvfb-stop.sh
