import os

from sandbox import sdk2
from sandbox.projects.maps.mobile.MapsMobileBuildAndroidProject import MapsMobileBuildAndroidProject
from sandbox.projects.maps.mobile.MapsMobileResources import MapsMobileAar


class MapsMobileBuildAndroidAar(MapsMobileBuildAndroidProject):
    ''' Task for building mobile aars '''

    class Parameters(MapsMobileBuildAndroidProject.Parameters):
        with sdk2.parameters.Group('Aar build') as aar_block:
            custom_aar_path = sdk2.parameters.String('Custom path to aar', required=False)

    def _create_resource(self, project_file, revision):
        return MapsMobileAar(
            self,
            '{} version {}'.format(project_file, revision),
            '{}.tgz'.format(project_file),
            ttl=31,
            backup_task=True
            )
    
    def _find_entry(self, dir_path, extension):
        for entry in os.listdir(dir_path):
            if entry.endswith(extension):
                return entry
        return None

    def _get_project_path(self, project_src_path):
        path_to_aar = self.Parameters.custom_aar_path
        if not path_to_aar:
            path_to_aar = os.path.join('build', 'outputs', 'aar')
        aar_dir = os.path.join(project_src_path, path_to_aar)
        aar_file = self._find_entry(aar_dir, '.aar')
        aar_path = os.path.join(aar_dir, aar_file)
        return aar_path

    def _get_resource_files_paths(self, project_src_path):
        paths = [self._get_project_path(project_src_path)]
        pom_dir = os.path.join(project_src_path, 'build')
        if os.path.exists(pom_dir):
            pom_file = self._find_entry(pom_dir, 'pom.xml')
            if pom_file:
                paths += [os.path.join(pom_dir, pom_file)]
        sources_dir = os.path.join(project_src_path, 'build', 'libs')
        if os.path.exists(sources_dir):
            sources_file = self._find_entry(sources_dir, 'sources.jar')
            if sources_file:
                paths += [os.path.join(sources_dir, sources_file)]
        return paths


