import os

from sandbox import sdk2
from sandbox.projects.maps.mobile.MapsMobileBuildAndroidProject import MapsMobileBuildAndroidProject
import sandbox.common.types.misc as ctm


class MapsMobileBuildAndroidApp(MapsMobileBuildAndroidProject):
    ''' Task for building mobile apps '''

    class Requirements(sdk2.Requirements):
        dns = ctm.DnsType.DNS64  # Needed for successful connection to Crashlytics servers

    class Parameters(MapsMobileBuildAndroidProject.Parameters):
        with sdk2.parameters.Group('App build') as app_block:
            custom_apk_path = sdk2.parameters.String('Custom path to apk', required=False)

    def _get_project_path(self, project_src_path):
        path_to_apk = self.Parameters.custom_apk_path
        if not path_to_apk:
            path_to_apk = os.path.join('build', 'outputs', 'apk', self.Parameters.build_variant)
        apk_dir = os.path.join(project_src_path, path_to_apk)
        for entry in os.listdir(apk_dir):
            if entry.endswith('.apk'):
                apk_file = entry
                break
        apk_path = os.path.join(apk_dir, apk_file)
        return apk_path
