import os
import logging
import shutil

from sandbox import sdk2
from sandbox.common.errors import TaskError
from sandbox.projects.maps.mobile.MapsMobileBuildIosProject import MapsMobileBuildIosProject
from sandbox.projects.maps.mobile.MapsMobileResources import MapsMobileIosFramework
from sandbox.projects.maps.mobile.MapsMobileResources import MapsMobileIosResourceBundle
from sandbox.projects.maps.mobile.utils.subprocess_helpers import check_call_wrapper


class MapsMobileBuildIosResourceBundle(MapsMobileBuildIosProject):
    ''' Task for building ios fat frameworks and bundles '''

    def _create_resource(self, project_file, revision):
        return MapsMobileIosResourceBundle(
            self,
            '{} version {}'.format(project_file, revision),
            '{}.tgz'.format(project_file),
            ttl=31,
            backup_task=True
            )

    def _get_project_path(self, project_src_path):
        return self._result_product_path

    def _run_build(self, project_src_path):
        MapsMobileBuildIosProject._run_build(self, project_src_path)

        product_path = os.path.join(
            'Products',
            'Library',
            'Bundles',
            self.Parameters.project + '.bundle')

        self._result_product_path = os.path.join(self._build_dir, 'device.xcarchive', product_path)
