import os
import logging

from sandbox import sdk2
from sandbox.projects.maps.mobile.MapsMobileBuildIosProject import MapsMobileBuildIosProject
from sandbox.projects.maps.mobile.MapsMobileResources import MapsMobileIosXcframework
from sandbox.projects.maps.mobile.utils.subprocess_helpers import check_call_wrapper


class MapsMobileBuildIosXcframework(MapsMobileBuildIosProject):
    ''' Task for building ios xcframeworks '''

    def _create_resource(self, project_file, revision):
        return MapsMobileIosXcframework(
            self,
            '{} version {}'.format(project_file, revision),
            '{}.tgz'.format(project_file),
            ttl=31,
            backup_task=True
            )

    def _get_project_path(self, project_src_path):
        return self._result_product_path

    def _merge_into_xcframework(self, device_product_path, emulator_product_path, result_path):
        self._result_product_path = os.path.join(result_path, self.Parameters.project + '.xcframework')

        xcode_args = ['xcodebuild', '-create-xcframework']

        if device_product_path:
            xcode_args += ['-framework', device_product_path]

        if emulator_product_path:
            xcode_args += ['-framework', emulator_product_path]

        xcode_args += ['-output', self._result_product_path]

        with sdk2.helpers.ProcessLog(self, logger=logging.getLogger('create_xcframework')) as pl:
            check_call_wrapper(
                xcode_args,
                stdout=pl.stdout,
                stderr=pl.stdout
                )

    def _run_build(self, project_src_path):
        MapsMobileBuildIosProject._run_build(self, project_src_path)

        product_path = os.path.join(
            'Products',
            'Library',
            'Frameworks',
            self.Parameters.project + '.framework')

        if self._has_device_archs:
            device_product_path = os.path.join(self._build_dir, 'device.xcarchive', product_path)
        else:
            device_product_path = None

        if self._has_emulator_archs:
            emulator_product_path = os.path.join(self._build_dir, 'emulator.xcarchive', product_path)
        else:
            emulator_product_path = None

        self._merge_into_xcframework(device_product_path, emulator_product_path, self._result_dir)
